/*
 * Decompiled with CFR 0.152.
 */
package io.timson.firehose.servlet;

import io.timson.firehose.request.RequestHandler;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RootServlet
extends HttpServlet {
    private final RequestHandler requestHandler;

    public RootServlet(RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String amzTarget;
        switch (amzTarget = this.extractAmzTarget(request)) {
            case "PutRecord": {
                this.requestHandler.handlePutRequest(request, response);
                return;
            }
            case "CreateDeliveryStream": {
                this.requestHandler.handleCreateStreamRequest(request, response);
                return;
            }
            case "DeleteDeliveryStream": {
                this.requestHandler.handleDeleteStreamRequest(request, response);
                return;
            }
        }
        response.setStatus(400);
    }

    private String extractAmzTarget(HttpServletRequest request) {
        String amzTarget = request.getHeader("X-Amz-Target");
        if (amzTarget == null || !amzTarget.startsWith("Firehose_20150804.")) {
            return "Unknown";
        }
        return amzTarget.substring("Firehose_20150804.".length());
    }
}

