/*
 * Decompiled with CFR 0.152.
 */
package io.timson.firehose.request;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import io.timson.firehose.request.CreateDeliveryStreamRequest;
import io.timson.firehose.request.DeleteDeliveryStreamRequest;
import io.timson.firehose.request.PutRequest;
import io.timson.firehose.response.CreateDeliveryStreamResponse;
import io.timson.firehose.response.DeleteDeliveryStreamResponse;
import io.timson.firehose.response.PutResponse;
import io.timson.firehose.stream.DeliveryStreamService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class RequestHandler {
    private final DeliveryStreamService deliveryStreamService;

    public RequestHandler(DeliveryStreamService deliveryStreamService) {
        this.deliveryStreamService = deliveryStreamService;
    }

    public void handlePutRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String json = this.extractRequestBody(request);
            PutRequest putRequest = PutRequest.fromJson(json);
            this.deliveryStreamService.write(putRequest.getDeliveryStream(), putRequest.getData());
        }
        catch (JsonParseException | JsonMappingException | IllegalArgumentException e) {
            response.setStatus(400);
            return;
        }
        response.setStatus(200);
        this.addBody(response, new PutResponse().body());
    }

    public void handleCreateStreamRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CreateDeliveryStreamRequest createDeliveryStreamRequest;
        try {
            String json = this.extractRequestBody(request);
            createDeliveryStreamRequest = CreateDeliveryStreamRequest.fromJson(json);
            this.deliveryStreamService.createStream(createDeliveryStreamRequest);
        }
        catch (JsonParseException | JsonMappingException | IllegalArgumentException e) {
            response.setStatus(400);
            return;
        }
        response.setStatus(200);
        String streamName = createDeliveryStreamRequest.getName();
        this.addBody(response, new CreateDeliveryStreamResponse(streamName).body());
    }

    public void handleDeleteStreamRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        DeleteDeliveryStreamRequest deleteDeliveryStreamRequest;
        try {
            String json = this.extractRequestBody(request);
            deleteDeliveryStreamRequest = DeleteDeliveryStreamRequest.fromJson(json);
            this.deliveryStreamService.deleteStream(deleteDeliveryStreamRequest.getName());
        }
        catch (JsonParseException | JsonMappingException | IllegalArgumentException e) {
            response.setStatus(400);
            return;
        }
        response.setStatus(200);
        String streamName = deleteDeliveryStreamRequest.getName();
        this.addBody(response, new DeleteDeliveryStreamResponse(streamName).body());
    }

    private String extractRequestBody(HttpServletRequest request) throws IOException {
        BufferedReader reader = request.getReader();
        return IOUtils.toString((Reader)reader);
    }

    private void addBody(HttpServletResponse response, String body) throws IOException {
        response.getWriter().write(body);
        response.getWriter().flush();
        response.getWriter().close();
    }
}

