/*
 * Decompiled with CFR 0.152.
 */
package io.timson.firehose.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;

public class PutRequest {
    private static final ObjectMapper mapper = new ObjectMapper();
    @JsonProperty(value="DeliveryStreamName")
    private String deliveryStream;
    private String data;

    @JsonProperty(value="Record")
    public void setData(Map<String, String> record) {
        String encodedData = record.get("Data");
        byte[] decodedData = Base64.getDecoder().decode(encodedData);
        this.data = new String(decodedData, StandardCharsets.UTF_8);
    }

    public static PutRequest fromJson(String json) throws IOException {
        return (PutRequest)mapper.readValue(json, PutRequest.class);
    }

    public String getDeliveryStream() {
        return this.deliveryStream;
    }

    public String getData() {
        return this.data;
    }
}

