/*
 * Decompiled with CFR 0.152.
 */
package io.timson.firehose;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import io.timson.firehose.aws.S3Client;
import io.timson.firehose.request.RequestHandler;
import io.timson.firehose.servlet.RootServlet;
import io.timson.firehose.stream.DeliveryStreamFactory;
import io.timson.firehose.stream.DeliveryStreamService;
import io.timson.firehose.util.FirehoseUtil;
import java.util.HashSet;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class FirehoseMock {
    private final Server server;
    private final Integer port;
    private final DeliveryStreamService deliveryStreamService;

    private FirehoseMock(Integer port, AmazonS3 amazonS3Client) {
        this.port = port;
        this.server = new Server(port.intValue());
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        S3Client s3Client = new S3Client(amazonS3Client);
        DeliveryStreamFactory deliveryStreamFactory = new DeliveryStreamFactory(s3Client);
        this.deliveryStreamService = new DeliveryStreamService(deliveryStreamFactory);
        RequestHandler requestHandler = new RequestHandler(this.deliveryStreamService);
        context.addServlet(new ServletHolder((Servlet)new RootServlet(requestHandler)), "/*");
    }

    public void start() throws Exception {
        if (!this.server.isStarted()) {
            this.server.start();
            while (!this.server.isRunning()) {
                Thread.sleep(1L);
            }
        }
    }

    public void stop() throws Exception {
        if (this.server.isRunning()) {
            HashSet<String> streams = new HashSet<String>(this.deliveryStreamService.listStreams());
            streams.forEach(this.deliveryStreamService::deleteStream);
            this.server.stop();
            while (this.server.isRunning()) {
                Thread.sleep(1L);
            }
        }
    }

    public Integer getPort() {
        return this.port;
    }

    public static FirehoseMock defaultMock() {
        return new Builder().build();
    }

    public static class Builder {
        private Integer port;
        private AmazonS3 amazonS3Client;

        public Builder withPort(Integer port) {
            this.port = port;
            return this;
        }

        public Builder withAmazonS3Client(AmazonS3 amazonS3Client) {
            this.amazonS3Client = amazonS3Client;
            return this;
        }

        public FirehoseMock build() {
            if (this.port == null) {
                this.port = FirehoseUtil.randomFreePort();
            }
            if (this.amazonS3Client == null) {
                this.amazonS3Client = AmazonS3ClientBuilder.defaultClient();
            }
            return new FirehoseMock(this.port, this.amazonS3Client);
        }
    }
}

