/*
 * Decompiled with CFR 0.152.
 */
package io.ticktok.client.tick.http;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import io.ticktok.client.tick.TickChannel;
import io.ticktok.client.tick.TickConsumer;
import io.ticktok.client.tick.TickConsumerInvoker;
import io.ticktok.client.tick.TickerPolicy;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTickerPolicy
implements TickerPolicy {
    private static final Logger log = LoggerFactory.getLogger(HttpTickerPolicy.class);
    public static final String URL_PARAM = "url";
    private final HttpClient httpClient = HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false)).build();
    private Timer timer;

    @Override
    public TickConsumerInvoker createConsumer(TickChannel channel) {
        this.createTimerIfNeeded();
        return this.createScheduledInvokerFor(channel);
    }

    private TickConsumerInvoker createScheduledInvokerFor(TickChannel channel) {
        HttpTickConsumerInvoker tickConsumerInvoker = new HttpTickConsumerInvoker(channel.getDetails().get(URL_PARAM));
        this.timer.scheduleAtFixedRate((TimerTask)tickConsumerInvoker, 0L, 1000L);
        return tickConsumerInvoker;
    }

    private void createTimerIfNeeded() {
        if (this.timer == null) {
            this.timer = new Timer();
        }
    }

    @Override
    public String idKey() {
        return URL_PARAM;
    }

    @Override
    public void disconnect() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private class HttpTickConsumerInvoker
    extends TimerTask
    implements TickConsumerInvoker {
        private TickConsumer tickConsumer;
        private final String url;

        public HttpTickConsumerInvoker(String url) {
            this.url = url;
        }

        @Override
        public void run() {
            if (this.ticksAvailableOn(this.url)) {
                this.tickConsumer.consume();
            }
        }

        private boolean ticksAvailableOn(String url) {
            try {
                HttpResponse response = HttpTickerPolicy.this.httpClient.execute((HttpUriRequest)new HttpGet(url));
                return this.isOk(response) && this.ticksFrom(response).size() > 0;
            }
            catch (IOException e) {
                log.warn("Failed to fetch ticks", (Throwable)e);
                return false;
            }
        }

        private boolean isOk(HttpResponse response) {
            return response.getStatusLine().getStatusCode() == 200;
        }

        private JsonArray ticksFrom(HttpResponse response) throws IOException {
            return (JsonArray)new Gson().fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), JsonArray.class);
        }

        @Override
        public void setTickConsumer(TickConsumer tickConsumer) {
            this.tickConsumer = tickConsumer;
        }
    }
}

