/*
 * Decompiled with CFR 0.152.
 */
package io.ticktok.client.tick;

import io.ticktok.client.tick.ChannelTypeUnsupportedException;
import io.ticktok.client.tick.TickChannel;
import io.ticktok.client.tick.TickConsumer;
import io.ticktok.client.tick.Ticker;
import io.ticktok.client.tick.http.HttpTickerPolicy;
import io.ticktok.client.tick.rabbit.RabbitTickerPolicy;
import java.util.HashMap;
import java.util.Map;

public class TickListener {
    public static final String RABBIT = "rabbit";
    public static final String HTTP = "http";
    private final Map<String, Ticker> tickers = new HashMap<String, Ticker>();

    public TickListener() {
        this.tickers.put(RABBIT, new Ticker(new RabbitTickerPolicy()));
        this.tickers.put(HTTP, new Ticker(new HttpTickerPolicy()));
    }

    public TickRegistrar forChannel(TickChannel channel) {
        this.validateChannelType(channel);
        return new TickRegistrar(this.tickers.get(channel.getType()), channel);
    }

    private void validateChannelType(TickChannel channel) {
        if (!this.tickers.containsKey(channel.getType())) {
            throw new ChannelTypeUnsupportedException(String.format("Channel type: %s is unsupported", channel.getType()));
        }
    }

    public void disconnect() {
        this.tickers.values().forEach(Ticker::disconnect);
    }

    public static class TickRegistrar {
        private final Ticker ticker;
        private final TickChannel channel;

        public TickRegistrar(Ticker ticker, TickChannel channel) {
            this.ticker = ticker;
            this.channel = channel;
        }

        public void register(TickConsumer consumer) {
            this.ticker.register(this.channel, consumer);
        }
    }
}

