/*
 * Decompiled with CFR 0.152.
 */
package io.ticktok.client.server.rest;

import com.google.gson.Gson;
import io.ticktok.client.TicktokOptions;
import io.ticktok.client.server.Clock;
import io.ticktok.client.server.ClockRequest;
import io.ticktok.client.server.ConnectionException;
import io.ticktok.client.server.FailToCreateClockException;
import io.ticktok.client.server.rest.ClocksUrlResolver;
import io.ticktok.client.server.rest.RestResponseValidator;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.util.EntityUtils;

public class RestClockCreator {
    private final HttpClient httpClient = HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler()).build();
    private final ClocksUrlResolver urlResolver;

    public RestClockCreator(TicktokOptions options) {
        this.urlResolver = new ClocksUrlResolver(options);
    }

    public Clock create(ClockRequest clockRequest) {
        try {
            HttpPost httpPost = new HttpPost(this.urlResolver.resolve());
            httpPost.setEntity((HttpEntity)new StringEntity(new Gson().toJson((Object)clockRequest), ContentType.APPLICATION_JSON));
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
            String entity = this.extractEntityFrom(httpResponse);
            this.validateResponse(httpResponse, entity);
            return this.clockFrom(entity);
        }
        catch (IOException e) {
            throw new ConnectionException("Connection error", e);
        }
    }

    private String extractEntityFrom(HttpResponse httpResponse) throws IOException {
        return EntityUtils.toString((HttpEntity)httpResponse.getEntity());
    }

    private void validateResponse(HttpResponse httpResponse, String entity) throws IOException {
        new RestResponseValidator(httpResponse).created(new FailToCreateClockException(entity));
    }

    private Clock clockFrom(String entity) {
        return (Clock)new Gson().fromJson(entity, Clock.class);
    }
}

