/*
 * Decompiled with CFR 0.152.
 */
package io.ticktok.client.server.rest;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.ticktok.client.TicktokOptions;
import io.ticktok.client.server.Clock;
import io.ticktok.client.server.ClockNotFoundException;
import io.ticktok.client.server.ClockRequest;
import io.ticktok.client.server.ConnectionException;
import io.ticktok.client.server.FailToActOnClockException;
import io.ticktok.client.server.rest.ClocksUrlResolver;
import io.ticktok.client.server.rest.RestResponseValidator;
import java.io.IOException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.util.EntityUtils;

public class RestClockActions {
    private final HttpClient httpClient = HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler()).build();
    private final ClocksUrlResolver urlResolver;

    public RestClockActions(TicktokOptions options) {
        this.urlResolver = new ClocksUrlResolver(options);
    }

    public void tick(ClockRequest clockRequest) {
        try {
            Clock clockBy = this.getClockBy(clockRequest);
            HttpPut httpPut = new HttpPut(this.urlResolver.pathParam(clockBy.getId()).pathParam("tick").resolve());
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPut);
            new RestResponseValidator(httpResponse).ok(new FailToActOnClockException("Failed to tick clock" + clockRequest.toString()));
        }
        catch (IOException e) {
            throw new ConnectionException("Connection error", e);
        }
    }

    private Clock getClockBy(ClockRequest clockRequest) throws IOException {
        HttpGet httpGet = new HttpGet(this.urlResolver.queryParam("name", clockRequest.getName()).queryParam("schedule", clockRequest.getSchedule()).resolve());
        HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpGet);
        return this.firstClockFrom(this.extractEntityFrom(httpResponse), clockRequest.getName(), clockRequest.getSchedule());
    }

    private Clock firstClockFrom(String entity, String name, String schedule) {
        List clocks = (List)new Gson().fromJson(entity, new TypeToken<List<Clock>>(){}.getType());
        if (clocks.isEmpty()) {
            throw new ClockNotFoundException(String.format("Clock named: %s, schedule: %s isn't currently configured", name, schedule));
        }
        return (Clock)clocks.get(0);
    }

    private String extractEntityFrom(HttpResponse httpResponse) throws IOException {
        return EntityUtils.toString((HttpEntity)httpResponse.getEntity());
    }
}

