/*
 * Decompiled with CFR 0.152.
 */
package io.ticktok.client.tick.rabbit;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import io.ticktok.client.tick.TickChannel;
import io.ticktok.client.tick.TickConsumer;
import io.ticktok.client.tick.TickConsumerInvoker;
import io.ticktok.client.tick.TickerPolicy;
import io.ticktok.client.tick.rabbit.ChannelException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;

public class RabbitTickerPolicy
implements TickerPolicy {
    public static final String URI_PARAM = "uri";
    public static final String QUEUE_PARAM = "queue";
    private final Object lock = new Object();
    private Connection connection;
    private Channel channel;

    @Override
    public TickConsumerInvoker createConsumer(TickChannel tickChannel) {
        try {
            this.createChannelIfNeededOn(tickChannel.getDetails().get(URI_PARAM));
            return this.createScheduledInvokerFor(tickChannel);
        }
        catch (Exception e) {
            throw new ChannelException(MessageFormat.format("Failed to connect to queue: {0}, with uri: {1}", tickChannel.getDetails().get(QUEUE_PARAM), tickChannel.getDetails().get(URI_PARAM)), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createChannelIfNeededOn(String uri) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.connection == null) {
                this.connection = this.createConnectionFactoryFor(uri).newConnection();
                this.channel = this.connection.createChannel();
            }
        }
    }

    private ConnectionFactory createConnectionFactoryFor(String uri) throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        ConnectionFactory factory = new ConnectionFactory();
        factory.setUri(URI.create(uri));
        return factory;
    }

    private RabbitTickConsumerInvoker createScheduledInvokerFor(TickChannel tickChannel) throws IOException {
        RabbitTickConsumerInvoker rabbitTickConsumerInvoker = new RabbitTickConsumerInvoker(this.channel);
        this.channel.basicConsume(tickChannel.getDetails().get(QUEUE_PARAM), true, (Consumer)rabbitTickConsumerInvoker);
        return rabbitTickConsumerInvoker;
    }

    @Override
    public String idKey() {
        return QUEUE_PARAM;
    }

    @Override
    public void disconnect() {
        this.closeChannel();
        this.closeConnection();
    }

    private void closeChannel() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.channel = null;
        }
    }

    private void closeConnection() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.connection = null;
        }
    }

    private class RabbitTickConsumerInvoker
    extends DefaultConsumer
    implements TickConsumerInvoker {
        private TickConsumer tickConsumer;

        public RabbitTickConsumerInvoker(Channel channel) {
            super(channel);
        }

        public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
            this.tickConsumer.consume();
        }

        @Override
        public void setTickConsumer(TickConsumer tickConsumer) {
            this.tickConsumer = tickConsumer;
        }
    }
}

