/*
 * Decompiled with CFR 0.152.
 */
package io.ticktok.client.tick;

import io.ticktok.client.tick.TickChannel;
import io.ticktok.client.tick.TickConsumer;
import io.ticktok.client.tick.TickConsumerInvoker;
import io.ticktok.client.tick.TickerPolicy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Ticker {
    private final TickerPolicy policy;
    private Map<String, TickConsumerInvoker> consumers = new ConcurrentHashMap<String, TickConsumerInvoker>();

    public Ticker(TickerPolicy policy) {
        this.policy = policy;
    }

    public synchronized void register(TickChannel channel, TickConsumer consumer) {
        String key = channel.getDetails().get(this.policy.idKey());
        if (!this.consumers.containsKey(key)) {
            TickConsumerInvoker invoker = this.policy.createConsumer(channel);
            this.consumers.put(key, invoker);
        }
        this.consumers.get(key).setTickConsumer(consumer);
    }

    public void disconnect() {
        this.policy.disconnect();
        this.consumers.clear();
    }
}

