/*
 * Decompiled with CFR 0.152.
 */
package io.ticktok.client.server.rest;

import com.google.gson.Gson;
import io.ticktok.client.TicktokOptions;
import io.ticktok.client.server.Clock;
import io.ticktok.client.server.ClockNotFoundException;
import io.ticktok.client.server.ClockRequest;
import io.ticktok.client.server.ConnectionException;
import io.ticktok.client.server.FailToActOnClockException;
import io.ticktok.client.server.rest.ClocksUrlResolver;
import io.ticktok.client.server.rest.RestResponseValidator;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.util.EntityUtils;

public class RestClockActions {
    private final HttpClient httpClient = HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler()).build();
    private final ClocksUrlResolver urlResolver;

    public RestClockActions(TicktokOptions options) {
        this.urlResolver = new ClocksUrlResolver(options);
    }

    public void tick(ClockRequest clockRequest) {
        try {
            Clock clockBy = this.getClockBy(clockRequest);
            HttpPut httpPut = new HttpPut(this.urlResolver.pathParam(clockBy.getId()).pathParam("tick").resolve());
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPut);
            new RestResponseValidator(httpResponse).validate(204, new FailToActOnClockException("Failed to tick clock" + clockRequest.toString()));
        }
        catch (IOException e) {
            throw new ConnectionException("Connection error", e);
        }
    }

    private Clock getClockBy(ClockRequest clockRequest) throws IOException {
        HttpGet httpGet = new HttpGet(this.urlResolver.queryParam("name", clockRequest.getName()).queryParam("schedule", clockRequest.getSchedule()).resolve());
        HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpGet);
        String entity = this.extractEntityFrom(httpResponse);
        new RestResponseValidator(httpResponse).validate(200, new ClockNotFoundException(entity));
        return this.clockFrom(entity);
    }

    private String extractEntityFrom(HttpResponse httpResponse) throws IOException {
        return EntityUtils.toString((HttpEntity)httpResponse.getEntity());
    }

    private Clock clockFrom(String entity) {
        return (Clock)new Gson().fromJson(entity, Clock.class);
    }
}

