/*
 * Decompiled with CFR 0.152.
 */
package io.ticktok.client.server.rest;

import io.ticktok.client.TicktokException;
import io.ticktok.client.TicktokOptions;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

public class ClocksUrlResolver {
    public static final String CLOCK_ROOT = "api/v1/clocks";
    private StringBuilder resolved = new StringBuilder();
    private List<NameValuePair> qParams = new ArrayList<NameValuePair>();
    private TicktokOptions options;

    public ClocksUrlResolver(TicktokOptions options) {
        this.options = options;
        this.bootstrapResolver();
    }

    private void bootstrapResolver() {
        this.resolved.append(this.options.getDomain()).append(this.shouldAppendBackSlash(this.options.getDomain()) ? "/" : "").append(CLOCK_ROOT);
    }

    private boolean shouldAppendBackSlash(String domain) {
        return !domain.substring(domain.length() - 1).equals("/");
    }

    public String resolve() {
        String result = this.buildUri();
        result = this.decodeUri(result);
        this.resetQparams();
        this.resetResolver();
        return result;
    }

    private String decodeUri(String result) {
        try {
            return URLDecoder.decode(result, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new TicktokException("Fail to decode uri, root cause: " + e);
        }
    }

    private String buildUri() {
        try {
            return new URIBuilder(this.resolved.toString()).setParameters(this.qParams).setParameter("access_token", this.options.getToken()).build().toString();
        }
        catch (URISyntaxException e) {
            throw new TicktokException("URI is invalid, root cause: " + e);
        }
    }

    private void resetQparams() {
        this.qParams = new ArrayList<NameValuePair>();
    }

    private void resetResolver() {
        this.resolved = new StringBuilder();
        this.bootstrapResolver();
    }

    public ClocksUrlResolver pathParam(String s) {
        this.resolved.append("/").append(s);
        return this;
    }

    public ClocksUrlResolver queryParam(String key, String value) {
        this.qParams.add((NameValuePair)new BasicNameValuePair(key, value));
        return this;
    }
}

