/*
 * Decompiled with CFR 0.152.
 */
package io.thundra.plugin.teamcity.foresight.utils;

import io.thundra.plugin.maven.test.instrumentation.MavenInstrumentationProcessor;
import io.thundra.plugin.maven.test.instrumentation.model.AgentParameter;
import io.thundra.plugin.teamcity.foresight.utils.IBuildToolForesightInitializer;
import io.thundra.plugin.teamcity.foresight.utils.ThundraUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jetbrains.buildServer.agent.BuildRunnerContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MavenBuildForesightInitializer
implements IBuildToolForesightInitializer {
    private static final Logger logger = LogManager.getLogger(MavenBuildForesightInitializer.class);
    public static final String THUNDRA_AGENT_DEBUG_ENABLE = "THUNDRA_AGENT_DEBUG_ENABLE";

    @Override
    public void initialize(BuildRunnerContext runner, String agentPath) {
        try {
            List<String> pomFiles = null;
            try (Stream<Path> paths = Files.walk(Paths.get(runner.getWorkingDirectory().getAbsolutePath(), new String[0]), new FileVisitOption[0]);){
                pomFiles = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().equals("pom.xml")).map(Path::toString).collect(Collectors.toList());
            }
            logger.info("<Execute> Executing maven instrumentation ...");
            logger.info(String.format("<Execute> Found %s pom.xml files", pomFiles.size()));
            if (pomFiles == null) {
                logger.error("<Error> pom.xml couldn't find for instrumentation ...");
                return;
            }
            String parentPomPath = ThundraUtils.getEnvVar(runner.getBuildParameters().getEnvironmentVariables(), "THUNDRA_MAVEN_INSTRUMENTATION_PARENT_POM");
            MavenInstrumentationProcessor.getInstance().process(agentPath, this.getAgentParameters(runner), pomFiles.toArray(new String[pomFiles.size()]), parentPomPath);
            logger.info("<Execute> Instrumentation is complete");
        }
        catch (IOException e) {
            logger.error("<Error> pom.xml couldn't find for instrumentation ...");
        }
    }

    private List<AgentParameter> getAgentParameters(BuildRunnerContext runner) {
        ArrayList<AgentParameter> agentParameters = new ArrayList<AgentParameter>();
        String apiKeyParam = ThundraUtils.getEnvVar(runner.getBuildParameters().getEnvironmentVariables(), "THUNDRA_APIKEY");
        String projectIdParam = ThundraUtils.getEnvVar(runner.getBuildParameters().getEnvironmentVariables(), "THUNDRA_AGENT_TEST_PROJECT_ID");
        String thundraRestBaseUrlParam = ThundraUtils.getEnvVar(runner.getBuildParameters().getEnvironmentVariables(), "THUNDRA_AGENT_REPORT_REST_BASEURL");
        String thundraAgentDebugEnableParam = ThundraUtils.getEnvVar(runner.getBuildParameters().getEnvironmentVariables(), THUNDRA_AGENT_DEBUG_ENABLE);
        agentParameters.add(new AgentParameter("-Dthundra.apiKey", apiKeyParam));
        agentParameters.add(new AgentParameter("-Dthundra.agent.test.project.id", projectIdParam));
        if (StringUtils.isNotEmpty((CharSequence)thundraRestBaseUrlParam)) {
            agentParameters.add(new AgentParameter("-Dthundra.agent.report.rest.baseurl", thundraRestBaseUrlParam));
        }
        if (StringUtils.isNotEmpty((CharSequence)thundraAgentDebugEnableParam)) {
            agentParameters.add(new AgentParameter("-Dthundra.agent.debug.enable", thundraAgentDebugEnableParam));
        }
        return agentParameters;
    }
}

