/*
 * Decompiled with CFR 0.152.
 */
package io.thundra.plugin.teamcity.foresight.utils;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import io.thundra.plugin.teamcity.foresight.utils.IBuildToolForesightInitializer;
import io.thundra.plugin.teamcity.foresight.utils.ThundraUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import jetbrains.buildServer.agent.BuildRunnerContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GradleBuildForesightInitializer
implements IBuildToolForesightInitializer {
    private static final Logger logger = LogManager.getLogger(GradleBuildForesightInitializer.class);

    @Override
    public void initialize(BuildRunnerContext runner, String agentPath) {
        try {
            String thundraApikey = ThundraUtils.getEnvVar(runner.getBuildParameters().getEnvironmentVariables(), "THUNDRA_APIKEY");
            String projectId = ThundraUtils.getEnvVar(runner.getBuildParameters().getEnvironmentVariables(), "THUNDRA_AGENT_TEST_PROJECT_ID");
            if (StringUtils.isEmpty((CharSequence)thundraApikey) || StringUtils.isEmpty((CharSequence)projectId)) {
                return;
            }
            File workingDirectory = runner.getWorkingDirectory();
            String thundraGradlePluginVersion = this.getPluginVersion();
            String initScriptPath = workingDirectory.getAbsolutePath();
            Configuration cfg = this.getFreemarkerConfiguration();
            HashMap<String, String> root = new HashMap<String, String>();
            String gradleVersionFromEnv = ThundraUtils.getEnvVar(runner.getBuildParameters().getEnvironmentVariables(), "THUNDRA_GRADLE_PLUGIN_VERSION");
            root.put("THUNDRA_GRADLE_PLUGIN_VERSION", StringUtils.isEmpty((CharSequence)gradleVersionFromEnv) ? thundraGradlePluginVersion : gradleVersionFromEnv);
            root.put("THUNDRA_AGENT_PATH", agentPath);
            Template template = cfg.getTemplate("thundrainit.ftlh");
            String initScriptName = initScriptPath + File.separator + "thundrainit.gradle";
            FileWriter fileOut = new FileWriter(initScriptName);
            template.process(root, (Writer)fileOut);
            this.addInitScriptParameters(runner, initScriptName);
        }
        catch (Exception ex) {
            logger.info("Thundra foresight gradle initialization failed", (Throwable)ex);
        }
    }

    @NotNull
    private Configuration getFreemarkerConfiguration() {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_31);
        cfg.setDefaultEncoding("UTF-8");
        cfg.setClassForTemplateLoading(this.getClass(), "/META-INF/template");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        cfg.setFallbackOnNullLoopVariable(false);
        return cfg;
    }

    @Override
    public String getAgentPath(BuildRunnerContext runner, String agentPath) {
        return agentPath;
    }

    private String getPluginVersion() throws XMLStreamException, IOException {
        BufferedInputStream in = new BufferedInputStream(new URL("https://repo1.maven.org/maven2/io/thundra/plugin/thundra-gradle-test-plugin/maven-metadata.xml").openStream());
        XMLStreamReader reader1 = XMLInputFactory.newInstance().createXMLStreamReader(in);
        String latestPluginVersion = "";
        while (reader1.hasNext()) {
            if (reader1.next() != 1 || !reader1.getLocalName().equals("latest")) continue;
            latestPluginVersion = reader1.getElementText();
            break;
        }
        logger.info("Latest Plugin Version : " + latestPluginVersion);
        return latestPluginVersion;
    }

    private void addInitScriptParameters(BuildRunnerContext runner, String initScriptPath) {
        String initScriptParams;
        String params;
        if (StringUtils.isNotEmpty((CharSequence)initScriptPath) && !(params = runner.getRunnerParameters().getOrDefault("ui.gradleRunner.additional.gradle.cmd.params", "")).contains(initScriptParams = "--init-script " + initScriptPath)) {
            runner.addRunnerParameter("ui.gradleRunner.additional.gradle.cmd.params", initScriptParams + " " + params);
        }
    }
}

