/*
 * Decompiled with CFR 0.152.
 */
package io.thundra.plugin.teamcity.foresight.utils;

import io.thundra.agent.maven.test.instrumentation.checker.FailsafeChecker;
import io.thundra.agent.maven.test.instrumentation.checker.SurefireChecker;
import io.thundra.plugin.teamcity.foresight.utils.IBuildToolForesightInitializer;
import java.io.File;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import jetbrains.buildServer.agent.BuildRunnerContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;

public class MavenBuildForesightInitializer
implements IBuildToolForesightInitializer {
    private static final Logger logger = LogManager.getLogger(MavenBuildForesightInitializer.class);

    @Override
    public void initialize(BuildRunnerContext runner, String agentPath) {
        File[] matchingFiles = runner.getWorkingDirectory().listFiles((dir, name) -> name.equals("pom.xml"));
        if (matchingFiles == null) {
            logger.error("<Error> pom.xml couldn't find for instrumentation ...");
            return;
        }
        String[] pomFiles = (String[])Arrays.stream(matchingFiles).map(File::getAbsolutePath).toArray(String[]::new);
        logger.info("<Execute> Executing maven instrumentation ...");
        logger.info(String.format("<Execute> Found %s pom.xml files", pomFiles.length));
        MavenXpp3Reader mavenReader = new MavenXpp3Reader();
        SurefireChecker surefireChecker = new SurefireChecker();
        FailsafeChecker failsafeChecker = new FailsafeChecker();
        AtomicBoolean surefireInstrumented = new AtomicBoolean();
        AtomicBoolean failsafeInstrumented = new AtomicBoolean();
        logger.info("<Execute> Processing the pom files");
        for (String pomFile : pomFiles) {
            logger.debug(String.format("<Execute> Processing %s", pomFile));
            logger.debug(String.format("<Execute> Checking %s for Surefire plugin", pomFile));
            surefireChecker.checkProfiles(logger, mavenReader, agentPath, pomFile, Boolean.valueOf(true));
            surefireChecker.checkPom(logger, mavenReader, agentPath, pomFile, Boolean.valueOf(true));
            surefireInstrumented.set(surefireChecker.instrumented.get() || surefireInstrumented.get());
            logger.debug(String.format("<Execute> Checking %s for Failsafe plugin", pomFile));
            failsafeChecker.checkProfiles(logger, mavenReader, agentPath, pomFile, Boolean.valueOf(true));
            failsafeChecker.checkPom(logger, mavenReader, agentPath, pomFile, Boolean.valueOf(true));
            failsafeInstrumented.set(failsafeChecker.instrumented.get() || failsafeInstrumented.get());
        }
        logger.info("<Execute> Instrumentation is complete");
    }

    @Override
    public String getAgentPath(BuildRunnerContext runner, String agentPath) {
        String projectId = (String)runner.getBuildParameters().getEnvironmentVariables().get("THUNDRA_AGENT_TEST_PROJECT_ID");
        String apiKey = (String)runner.getBuildParameters().getEnvironmentVariables().get("THUNDRA_APIKEY");
        String thundraRestBaseUrl = (String)runner.getBuildParameters().getEnvironmentVariables().get("THUNDRA_AGENT_REPORT_REST_BASEURL");
        String restBaseUrlParam = StringUtils.isNotEmpty((CharSequence)thundraRestBaseUrl) ? " -Dthundra.agent.report.rest.baseurl=" + thundraRestBaseUrl : "";
        agentPath = agentPath + restBaseUrlParam;
        agentPath = agentPath + String.format(" -Dthundra.apiKey=%s -Dthundra.agent.test.project.id=%s", apiKey, projectId);
        return agentPath;
    }
}

