/*
 * Decompiled with CFR 0.152.
 */
package io.thundra.plugin.teamcity.foresight;

import io.thundra.plugin.teamcity.foresight.BuildToolForesightInitializerFactory;
import io.thundra.plugin.teamcity.foresight.utils.IBuildToolForesightInitializer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.EventListener;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import jetbrains.buildServer.ExtensionHolder;
import jetbrains.buildServer.agent.AgentLifeCycleAdapter;
import jetbrains.buildServer.agent.AgentLifeCycleListener;
import jetbrains.buildServer.agent.AgentRunningBuild;
import jetbrains.buildServer.agent.BuildRunnerContext;
import jetbrains.buildServer.util.EventDispatcher;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ThundraForesightAgentLifeCycleAdapter
extends AgentLifeCycleAdapter {
    private static final Logger log = LogManager.getLogger(ThundraForesightAgentLifeCycleAdapter.class);
    private final ExtensionHolder extensionHolder;
    private final BuildToolForesightInitializerFactory buildToolForesightInitializerFactory;
    private String agentPath;

    public void beforeRunnerStart(@NotNull BuildRunnerContext runner) {
        String thundraApikey = (String)runner.getBuildParameters().getEnvironmentVariables().get("THUNDRA_APIKEY");
        String projectId = (String)runner.getBuildParameters().getEnvironmentVariables().get("THUNDRA_AGENT_TEST_PROJECT_ID");
        if (StringUtils.isEmpty((CharSequence)thundraApikey) || StringUtils.isEmpty((CharSequence)projectId)) {
            return;
        }
        IBuildToolForesightInitializer initializer = this.buildToolForesightInitializerFactory.getInitializer(runner.getRunType());
        if (ObjectUtils.isNotEmpty((Object)initializer)) {
            try {
                File workingDirectory = runner.getWorkingDirectory();
                this.getThundraAgent(workingDirectory.getAbsolutePath());
                this.agentPath = initializer.getAgentPath(runner, this.agentPath);
                initializer.initialize(runner, this.agentPath);
            }
            catch (IOException | XMLStreamException e) {
                e.printStackTrace();
            }
        }
        super.beforeRunnerStart(runner);
    }

    public ThundraForesightAgentLifeCycleAdapter(@NotNull EventDispatcher<AgentLifeCycleListener> dispatcher, @NotNull ExtensionHolder extensionHolder, BuildToolForesightInitializerFactory buildToolForesightInitializerFactory) {
        this.extensionHolder = extensionHolder;
        this.buildToolForesightInitializerFactory = buildToolForesightInitializerFactory;
        dispatcher.addListener((EventListener)((Object)this));
    }

    public void buildStarted(@NotNull AgentRunningBuild build) {
    }

    protected void getThundraAgent(String agentDirPath) throws IOException, XMLStreamException {
        String latestAgentVersion = "";
        BufferedInputStream in = new BufferedInputStream(new URL("https://repo.thundra.io/service/local/repositories/thundra-releases/content/io/thundra/agent/thundra-agent-bootstrap/maven-metadata.xml").openStream());
        XMLStreamReader reader1 = XMLInputFactory.newInstance().createXMLStreamReader(in);
        while (reader1.hasNext()) {
            if (reader1.next() != 1 || !reader1.getLocalName().equals("latest")) continue;
            latestAgentVersion = reader1.getElementText();
            break;
        }
        log.info("Latest Agent Version : " + latestAgentVersion);
        if (StringUtils.isNotEmpty((CharSequence)latestAgentVersion)) {
            BufferedInputStream agentStream = new BufferedInputStream(new URL(String.format("https://repo.thundra.io/service/local/repositories/thundra-releases/content/io/thundra/agent/thundra-agent-bootstrap/%s/thundra-agent-bootstrap-%s.jar", latestAgentVersion, latestAgentVersion)).openStream());
            String jarPath = agentDirPath + "/thundra-agent-bootstrap.jar";
            File file = new File(jarPath);
            Files.copy(agentStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.agentPath = jarPath;
        }
        log.info("Thundra Foresight Instrumentation started");
    }
}

