/*
 * Decompiled with CFR 0.152.
 */
package io.thundra.plugin.gradle;

import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.process.JavaForkOptions;

public class ThundraExtension {
    private static final Logger LOGGER = Logging.getLogger(ThundraExtension.class);
    private String agentPath;

    public String getAgentPath() {
        return this.agentPath;
    }

    public void setAgentPath(String agentPath) {
        this.agentPath = agentPath;
    }

    public <T extends Task & JavaForkOptions> void apply(T task) {
        if (this.getAgentPath() == null || this.getAgentPath().isEmpty()) {
            throw new GradleException("Thundra Agent path is null or empty.");
        }
        LOGGER.debug("Add Thundra Java agent " + this.getAgentPath() + " to " + task.getName());
        ((JavaForkOptions)task).jvmArgs(new Object[]{this.getJvmArgs()});
    }

    private String getJvmArgs() {
        try {
            return "-javaagent:" + this.getAgentPath();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

