/*
 * Decompiled with CFR 0.152.
 */
package io.thill.kafkalite.client;

import io.thill.kafkalite.KafkaLite;
import io.thill.kafkalite.internal.KafkaLiteConfig;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;

public class KafkaLiteClient
implements AutoCloseable {
    private final Time time = new SystemTime();
    private final ZooKeeperClient zkClient = new ZooKeeperClient("localhost:" + KafkaLiteConfig.ZK_PORT, 1000, 1000, 1, this.time, "DEFAULT", "DEFAULT");
    private final KafkaZkClient kafkaZkClient = new KafkaZkClient(this.zkClient, false, this.time);
    private final AdminZkClient adminZkClient = new AdminZkClient(this.kafkaZkClient);
    private final KafkaConsumer<byte[], byte[]> kafkaConsumer = new KafkaConsumer(KafkaLite.consumerProperties(ByteArrayDeserializer.class, ByteArrayDeserializer.class));

    public ZooKeeperClient zkClient() {
        return this.zkClient;
    }

    public KafkaZkClient kafkaZkClient() {
        return this.kafkaZkClient;
    }

    public AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    public KafkaConsumer<byte[], byte[]> kafkaConsumer() {
        return this.kafkaConsumer;
    }

    @Override
    public void close() {
        this.kafkaConsumer.close();
        this.kafkaZkClient.close();
        this.zkClient.close();
    }
}

