/*
 * Decompiled with CFR 0.152.
 */
package io.thill.kafkacap.websocket.internal;

import io.thill.kafkacap.core.capture.BufferedPublisher;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientEndpoint
public class WebsocketClient {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final URI endpointUri;
    private final Charset textCharset;
    private final BufferedPublisher<byte[], byte[]> bufferedPublisher;
    private volatile Session userSession;
    private volatile boolean closed;

    public WebsocketClient(URI endpointUri, Charset textCharset, BufferedPublisher<byte[], byte[]> bufferedPublisher) {
        this.endpointUri = endpointUri;
        this.textCharset = textCharset;
        this.bufferedPublisher = bufferedPublisher;
    }

    public void connect() throws IOException, DeploymentException {
        WebSocketContainer container = ContainerProvider.getWebSocketContainer();
        container.connectToServer((Object)this, this.endpointUri);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() throws IOException {
        if (this.userSession != null) {
            this.userSession.close();
            this.userSession = null;
        }
    }

    @OnOpen
    public void onOpen(Session userSession) {
        this.logger.info("WebSocket Open. endpointUri={}", (Object)this.endpointUri);
    }

    @OnClose
    public void onClose(Session userSession, CloseReason reason) {
        this.logger.info("WebSocket Closed. reason={}", (Object)reason);
        this.closed = true;
    }

    @OnMessage
    public void onMessage(byte[] message) {
        this.bufferedPublisher.write(message);
    }

    @OnMessage
    public void onMessage(String message) {
        this.bufferedPublisher.write(message.getBytes(this.textCharset));
    }

    public String toString() {
        return "WebsocketClient{endpoint=" + this.endpointUri + '}';
    }
}

