/*
 * Decompiled with CFR 0.152.
 */
package io.theysay.affectr.client.utils;

import io.theysay.affectr.client.exceptions.AffectRException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class HttpClient {
    public static final HttpClient DEFAULT = new HttpClient();
    public static final String CHARSET = "UTF-8";
    public static final String CONTENT_TYPE = "application/json";
    public static final String USER_AGENT = String.format("affectr-java/%s", "1.0.0");
    public static final Map<String, String> BASE_HEADERS = HttpClient.headers();
    protected int connectTimeout = 30000;
    protected int readTimeout = 60000;

    public String get(String url, Map<String, String> headers) {
        return this.request(RequestMethod.GET, url, headers, null);
    }

    public String post(String url, Map<String, String> headers, String payload) {
        return this.request(RequestMethod.POST, url, headers, payload);
    }

    public String put(String url, Map<String, String> headers, String payload) {
        return this.request(RequestMethod.PUT, url, headers, payload);
    }

    public String delete(String url, Map<String, String> headers, String payload) {
        return this.request(RequestMethod.DELETE, url, headers, payload);
    }

    public static String url(String url, Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return url;
        }
        return String.format("%s?%s", url, HttpClient.createQuery(params));
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    protected String request(RequestMethod method, String url, Map<String, String> headers, String payload) {
        HttpURLConnection conn = null;
        try {
            conn = this.createConnection(url);
            headers = headers != null ? headers : new HashMap();
            for (Map.Entry header : headers.entrySet()) {
                conn.setRequestProperty((String)header.getKey(), (String)header.getValue());
            }
            if (method.equals((Object)RequestMethod.GET)) {
                conn.setRequestMethod("GET");
            } else if (method.equals((Object)RequestMethod.POST)) {
                conn.setRequestMethod("POST");
                this.writeOutput(conn, payload);
            } else if (method.equals((Object)RequestMethod.PUT)) {
                conn.setRequestMethod("PUT");
                this.writeOutput(conn, payload);
            } else {
                throw new AffectRException(String.format("Unsupported Request Method [method: %s, url: %s]", new Object[]{method, url}));
            }
            int statusCode = conn.getResponseCode();
            if (statusCode < 200 || statusCode >= 300) {
                throw new AffectRException(url + " with status " + statusCode + " = " + this.getResponse(conn.getErrorStream()));
            }
            String string = this.getResponse(conn.getInputStream());
            return string;
        }
        catch (IOException ex) {
            throw new AffectRException(String.format("Failed request [url: %s]", url), ex);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeOutput(URLConnection connection, String payload) throws IOException {
        if (payload != null) {
            connection.setDoOutput(true);
            try (OutputStream output = null;){
                output = connection.getOutputStream();
                output.write(payload.getBytes(CHARSET));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getResponse(InputStream response) throws IOException {
        try {
            String string = new Scanner(response, CHARSET).useDelimiter("\\A").next();
            return string;
        }
        finally {
            response.close();
        }
    }

    protected HttpURLConnection createConnection(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setConnectTimeout(this.connectTimeout);
        conn.setReadTimeout(this.readTimeout);
        conn.setUseCaches(false);
        for (Map.Entry<String, String> header : BASE_HEADERS.entrySet()) {
            conn.setRequestProperty(header.getKey(), header.getValue());
        }
        return conn;
    }

    protected static String createQuery(Map<String, String> params) {
        if (params == null) {
            return "";
        }
        try {
            StringBuilder query = new StringBuilder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (query.length() > 0) {
                    query.append("&");
                }
                String encodedKey = URLEncoder.encode(entry.getKey(), CHARSET);
                String encodedValue = URLEncoder.encode(entry.getValue(), CHARSET);
                query.append(String.format("%s=%s", encodedKey, encodedValue));
            }
            return query.toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Failed to encode params " + params.toString(), ex);
        }
    }

    protected static Map<String, String> headers() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", String.format("%s", CONTENT_TYPE));
        headers.put("Content-Type", String.format("%s;charset=%s", CONTENT_TYPE, CHARSET));
        headers.put("User-Agent", USER_AGENT);
        return headers;
    }

    protected static enum RequestMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

