/*
 * Decompiled with CFR 0.152.
 */
package io.theysay.affectr.client.api;

import io.theysay.affectr.client.AccountDetails;
import io.theysay.affectr.client.api.AggregateEntitySentiment;
import io.theysay.affectr.client.api.ChunkConstituent;
import io.theysay.affectr.client.api.Comparison;
import io.theysay.affectr.client.api.DependencyParse;
import io.theysay.affectr.client.api.EntityRelationSentiment;
import io.theysay.affectr.client.api.EntitySentiment;
import io.theysay.affectr.client.api.Intent;
import io.theysay.affectr.client.api.NamedEntity;
import io.theysay.affectr.client.api.PosTag;
import io.theysay.affectr.client.api.Request;
import io.theysay.affectr.client.api.Risk;
import io.theysay.affectr.client.api.SentenceSentiment;
import io.theysay.affectr.client.api.SentimentBias;
import io.theysay.affectr.client.api.SimpleSentiment;
import io.theysay.affectr.client.api.Speculation;
import io.theysay.affectr.client.api.TaxonomyEntitySentiment;
import io.theysay.affectr.client.api.Version;
import io.theysay.affectr.client.api.WordSentiment;
import io.theysay.affectr.client.utils.HttpClient;
import io.theysay.affectr.client.utils.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class Api {
    protected HttpClient httpClient = HttpClient.DEFAULT;
    protected AccountDetails accountDetails;

    public Api(AccountDetails accountDetails) {
        this.accountDetails = accountDetails;
    }

    public SimpleSentiment classifySentiment(String string) {
        return this.classifySentiment(string, null);
    }

    public SimpleSentiment classifySentiment(String string, SentimentBias sentimentBias) {
        return JsonUtils.fromJson(this.httpClient.post(Path.SENTIMENT, this.headers(), JsonUtils.toJson(new Request(string, sentimentBias))), SimpleSentiment.class);
    }

    public SentenceSentiment[] classifySentenceSentiment(String string) {
        return this.classifySentenceSentiment(string, null);
    }

    public SentenceSentiment[] classifySentenceSentiment(String string, SentimentBias sentimentBias) {
        return JsonUtils.fromJson(this.httpClient.post(Path.SENTIMENT, this.headers(), JsonUtils.toJson(new Request(string, "sentence", sentimentBias))), SentenceSentiment[].class);
    }

    public WordSentiment[] classifyWordSentiment(String string) {
        return this.classifyWordSentiment(string, null);
    }

    public WordSentiment[] classifyWordSentiment(String string, SentimentBias sentimentBias) {
        return JsonUtils.fromJson(this.httpClient.post(Path.SENTIMENT, this.headers(), JsonUtils.toJson(new Request(string, "word", sentimentBias))), WordSentiment[].class);
    }

    public EntitySentiment[] classifyEntitySentiment(String string) {
        return this.classifyEntitySentiment(string, null, null, null);
    }

    public EntitySentiment[] classifyEntitySentiment(String string, SentimentBias sentimentBias) {
        return this.classifyEntitySentiment(string, null, null, sentimentBias);
    }

    public EntitySentiment[] classifyEntitySentiment(String string, String string2) {
        return this.classifyEntitySentiment(string, string2, null, null);
    }

    public EntitySentiment[] classifyEntitySentiment(String string, String string2, SentimentBias sentimentBias) {
        return this.classifyEntitySentiment(string, string2, null, sentimentBias);
    }

    public EntitySentiment[] classifyEntitySentiment(String string, String string2, String string3) {
        return this.classifyEntitySentiment(string, string2, string3, null);
    }

    public EntitySentiment[] classifyEntitySentiment(String string, String string2, String string3, SentimentBias sentimentBias) {
        return JsonUtils.fromJson(this.httpClient.post(Path.SENTIMENT, this.headers(), JsonUtils.toJson(new Request(string, "entity", string2, string3, sentimentBias))), EntitySentiment[].class);
    }

    public AggregateEntitySentiment[] classifyAggregatedEntitySentiment(String string) {
        return this.classifyAggregatedEntitySentiment(string, null);
    }

    public AggregateEntitySentiment[] classifyAggregatedEntitySentiment(String string, SentimentBias sentimentBias) {
        return JsonUtils.fromJson(this.httpClient.post(Path.SENTIMENT, this.headers(), JsonUtils.toJson(new Request(string, "entityaggregate", sentimentBias))), AggregateEntitySentiment[].class);
    }

    public TaxonomyEntitySentiment[] classifyTaxonomyEntitySentiment(String string) {
        return this.classifyTaxonomyEntitySentiment(string, null);
    }

    public TaxonomyEntitySentiment[] classifyTaxonomyEntitySentiment(String string, SentimentBias sentimentBias) {
        return JsonUtils.fromJson(this.httpClient.post(Path.SENTIMENT, this.headers(), JsonUtils.toJson(new Request(string, "entitytaxonomy", sentimentBias))), TaxonomyEntitySentiment[].class);
    }

    public EntityRelationSentiment[] classifyEntityRelationSentiment(String string) {
        return this.classifyEntityRelationSentiment(string, null);
    }

    public EntityRelationSentiment[] classifyEntityRelationSentiment(String string, SentimentBias sentimentBias) {
        return JsonUtils.fromJson(this.httpClient.post(Path.SENTIMENT, this.headers(), JsonUtils.toJson(new Request(string, "entityrelation", sentimentBias))), EntityRelationSentiment[].class);
    }

    public Speculation[] classifySpeculation(String string) {
        return JsonUtils.fromJson(this.httpClient.post(Path.SPECULATION, this.headers(), JsonUtils.toJson(new Request(string))), Speculation[].class);
    }

    public Intent[] classifyIntent(String string) {
        return JsonUtils.fromJson(this.httpClient.post(Path.INTENT, this.headers(), JsonUtils.toJson(new Request(string))), Intent[].class);
    }

    public Risk[] classifyRisk(String string) {
        return JsonUtils.fromJson(this.httpClient.post(Path.RISK, this.headers(), JsonUtils.toJson(new Request(string))), Risk[].class);
    }

    public Comparison[] classifyComparison(String string) {
        return JsonUtils.fromJson(this.httpClient.post(Path.COMPARISON, this.headers(), JsonUtils.toJson(new Request(string))), Comparison[].class);
    }

    public NamedEntity[] getNamedEntities(String string) {
        return JsonUtils.fromJson(this.httpClient.post(Path.NAMED_ENTITY, this.headers(), JsonUtils.toJson(new Request(string))), NamedEntity[].class);
    }

    public PosTag[] posTag(String string) {
        return JsonUtils.fromJson(this.httpClient.post(Path.POS_TAG, this.headers(), JsonUtils.toJson(new Request(string))), PosTag[].class);
    }

    public DependencyParse[] dependencyParse(String string) {
        return JsonUtils.fromJson(this.httpClient.post(Path.DEPENDENCY_PARSE, this.headers(), JsonUtils.toJson(new Request(string))), DependencyParse[].class);
    }

    public ChunkConstituent[] chunkParse(String string) {
        return JsonUtils.fromJson(this.httpClient.post(Path.CHUNK_PARSE, this.headers(), JsonUtils.toJson(new Request(string))), ChunkConstituent[].class);
    }

    public Version getVersion() {
        return JsonUtils.fromJson(this.httpClient.get(Path.VERSION, this.headers()), Version.class);
    }

    protected Map<String, String> headers() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.accountDetails.getUsername() + ":" + this.accountDetails.getPassword();
        hashMap.put("Authorization", String.format("Basic %s", Base64.encodeBase64String((byte[])string.getBytes())));
        return hashMap;
    }

    public static interface Path {
        public static final String BASE = "http://api.theysay.io";
        public static final String SENTIMENT = String.format("%s/v1/sentiment", "http://api.theysay.io");
        public static final String SPECULATION = String.format("%s/v1/speculation", "http://api.theysay.io");
        public static final String INTENT = String.format("%s/v1/intent", "http://api.theysay.io");
        public static final String RISK = String.format("%s/v1/risk", "http://api.theysay.io");
        public static final String COMPARISON = String.format("%s/v1/comparison", "http://api.theysay.io");
        public static final String NAMED_ENTITY = String.format("%s/v1/namedentity", "http://api.theysay.io");
        public static final String POS_TAG = String.format("%s/v1/postag", "http://api.theysay.io");
        public static final String DEPENDENCY_PARSE = String.format("%s/v1/depparse", "http://api.theysay.io");
        public static final String CHUNK_PARSE = String.format("%s/v1/chunkparse", "http://api.theysay.io");
        public static final String VERSION = String.format("%s/version", "http://api.theysay.io");
    }
}

