/*
 * Decompiled with CFR 0.152.
 */
package io.theves.denon4j.net;

import io.theves.denon4j.net.Command;
import io.theves.denon4j.net.ConnectException;
import io.theves.denon4j.net.ConnectionException;
import io.theves.denon4j.net.Event;
import io.theves.denon4j.net.EventDispatcher;
import io.theves.denon4j.net.EventReader;
import io.theves.denon4j.net.ExecutionException;
import io.theves.denon4j.net.Protocol;
import io.theves.denon4j.net.TimeoutException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Tcp
implements Protocol {
    private final Logger logger = LoggerFactory.getLogger(Tcp.class);
    private final Integer port;
    private final String host;
    private final EventReader eventReader;
    private EventDispatcher eventDispatcher;
    private Socket socket;
    private Writer writer;
    private Event mostRecent;

    public Tcp(String host, Integer port) {
        this.host = Optional.ofNullable(host).orElse("127.0.0.1");
        this.port = Optional.ofNullable(port).orElse(23);
        this.socket = new Socket();
        this.eventReader = new EventReader(this, this.socket);
    }

    void received(Event event) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Event received: {}", (Object)event);
        }
        this.notify(event);
        this.mostRecent = event;
    }

    private void notify(Event event) {
        if (null != this.eventDispatcher) {
            try {
                this.eventDispatcher.dispatch(event);
            }
            catch (Exception e) {
                this.logger.warn("Error invoking event listener", (Throwable)e);
            }
        }
    }

    @Override
    public void establishConnection(int timeout) throws ConnectException {
        if (this.isConnected()) {
            throw new ConnectException("Already connected.");
        }
        try {
            this.socket.setSoTimeout(0);
            this.socket.connect(new InetSocketAddress(this.host, (int)this.port), timeout);
            this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), StandardCharsets.US_ASCII));
            this.eventReader.start();
        }
        catch (SocketTimeoutException ste) {
            throw new TimeoutException("Could not establish connection within timeout of " + timeout + " ms.", ste);
        }
        catch (IOException e) {
            throw new ConnectException("Cannot establishConnection to host/ip " + this.host + " on port " + this.port, e);
        }
    }

    @Override
    public boolean isConnected() {
        return null != this.socket && this.socket.isConnected();
    }

    @Override
    public void disconnect() {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.eventReader.interrupt();
            this.socket.close();
        }
        catch (IOException e) {
            this.logger.debug("Disconnect failure", (Throwable)e);
        }
    }

    @Override
    public void send(Command command) {
        this.checkConnection();
        this.doSend(command);
    }

    @Override
    public void setDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Event request(Command requestCommand) {
        EventReader eventReader = this.eventReader;
        synchronized (eventReader) {
            this.mostRecent = null;
            this.send(requestCommand);
            try {
                this.eventReader.wait();
            }
            catch (InterruptedException e) {
                this.logger.warn("Receive interrupted", (Throwable)e);
            }
            return Optional.ofNullable(this.mostRecent).orElseThrow(() -> new ExecutionException("Could not get response"));
        }
    }

    private void checkConnection() {
        if (!this.isConnected()) {
            throw new ConnectionException("Not connected.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend(Command command) {
        EventReader eventReader = this.eventReader;
        synchronized (eventReader) {
            try {
                this.writer.write(command.signature() + '\r');
                this.writer.flush();
            }
            catch (Exception e) {
                throw new ConnectionException("Communication failure.", e);
            }
        }
    }
}

