/*
 * Decompiled with CFR 0.152.
 */
package io.theves.denon4j.net;

import io.theves.denon4j.net.ConnectionException;
import io.theves.denon4j.net.Event;
import io.theves.denon4j.net.Tcp;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventReader
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(EventReader.class);
    private final Socket socket;
    private final Tcp client;
    private InputStream reader;

    EventReader(Tcp client, Socket socket) {
        super("EventReader");
        this.client = client;
        this.socket = socket;
    }

    @Override
    public void run() {
        this.openStream();
        this.logger.debug("Listening for events...");
        while (!this.isInterrupted()) {
            this.next();
        }
        this.logger.debug("Stopped.");
    }

    private void openStream() {
        try {
            this.reader = this.socket.getInputStream();
        }
        catch (IOException e) {
            throw new ConnectionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void next() {
        block8: {
            try {
                int read;
                ByteBuffer rawBuffer = ByteBuffer.allocate(135);
                while ((read = this.reader.read()) != -1 && 13 != read && 0 != read) {
                    rawBuffer.put((byte)read);
                }
                if (rawBuffer.position() <= 0) break block8;
                Event e = Event.create(Arrays.copyOfRange(rawBuffer.array(), 0, rawBuffer.position()));
                EventReader eventReader = this;
                synchronized (eventReader) {
                    this.client.received(e);
                    this.notify();
                }
            }
            catch (SocketException se) {
                if (!this.socket.isClosed() && !this.socket.isInputShutdown()) {
                    throw new ConnectionException("Socket error.", se);
                }
            }
            catch (Exception e) {
                throw new ConnectionException("Socket error.", e);
            }
        }
    }
}

