/*
 * Decompiled with CFR 0.152.
 */
package io.theves.denon4j.net;

import io.theves.denon4j.controls.Control;
import io.theves.denon4j.net.Event;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class EventDispatcher {
    private final Collection<Control> controls = new HashSet<Control>();
    private final Set<Event> unhandledEvents = new HashSet<Event>();

    public Set<Event> getUnhandledEvents() {
        return Collections.unmodifiableSet(this.unhandledEvents);
    }

    public void addControl(Control ctrl) {
        if (null != ctrl) {
            this.controls.add(ctrl);
        }
    }

    public void removeControl(Control ctrl) {
        if (null != ctrl) {
            this.controls.remove(ctrl);
        }
    }

    public Collection<Control> getControls() {
        return this.controls;
    }

    public void dispatch(Event event) {
        List<Control> supporters = this.controls.stream().filter(ctrl -> ctrl.supports(event)).collect(Collectors.toList());
        if (supporters.size() == 0) {
            this.unhandledEvents.add(event);
        } else {
            supporters.forEach(ctrl -> ctrl.handle(event));
        }
    }
}

