/*
 * Decompiled with CFR 0.152.
 */
package io.theves.denon4j.net;

import io.theves.denon4j.net.Event;
import io.theves.denon4j.net.Parameter;
import io.theves.denon4j.net.Protocol;
import io.theves.denon4j.net.RequestCommand;
import io.theves.denon4j.net.SetCommand;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Objects;

public class Command
extends Event {
    protected final Protocol protocol;
    private final String signature;
    private LocalDateTime executedAt = LocalDateTime.MIN;

    public Command(Protocol protocol, String prefix, Parameter parameter) {
        super((prefix + parameter.getValue()).getBytes(StandardCharsets.US_ASCII), prefix, parameter);
        this.protocol = Objects.requireNonNull(protocol);
        this.signature = this.getPrefix() + this.getParameter().getValue();
    }

    public static SetCommand createSetCommand(Protocol protocol, String prefix) {
        return new SetCommand(protocol, prefix);
    }

    public static Command createCommand(Protocol protocol, String command) {
        if (command == null || command.length() < 2) {
            throw new IllegalArgumentException("Command length must be > 2");
        }
        return Command.createCommand(protocol, command.substring(0, 2), command.substring(2));
    }

    public static Command createCommand(Protocol protocol, String prefix, String param) {
        if (Parameter.REQUEST.getValue().equals(param)) {
            return Command.createRequestCommand(protocol, prefix);
        }
        return new Command(protocol, prefix, Parameter.createParameter(param));
    }

    public static RequestCommand createRequestCommand(Protocol protocol, String prefix) {
        return new RequestCommand(protocol, prefix);
    }

    public int hashCode() {
        return Objects.hash(this.signature);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Command command = (Command)o;
        return Objects.equals(this.signature, command.signature);
    }

    public LocalDateTime getExecutedAt() {
        return this.executedAt;
    }

    public void execute() {
        this.doSend();
        this.executedAt = LocalDateTime.now();
    }

    protected void doSend() {
        this.protocol.send(this);
    }

    @Override
    public String toString() {
        return "Command{" + this.signature() + '}';
    }

    public String signature() {
        return this.signature;
    }
}

