/*
 * Decompiled with CFR 0.152.
 */
package io.theves.denon4j.controls;

import io.theves.denon4j.net.Event;

public class Line
implements Comparable<Line> {
    private Event event;
    private String displayLine;
    private boolean playable;
    private boolean directory;
    private boolean cursorSelect;
    private boolean picture;
    private Integer index;

    public Line(Event event) {
        this.event = event;
        this.parseDataByte(this.event);
    }

    private void parseDataByte(Event event) {
        byte[] raw = event.getRaw();
        if (raw.length > 4 && this.isDataByte(raw[4])) {
            byte data = raw[4];
            this.playable = this.isSet(data, 0);
            this.directory = this.isSet(data, 1);
            this.cursorSelect = this.isSet(data, 3);
            this.picture = this.isSet(data, 6);
        }
        this.displayLine = event.getParameter().getValue().substring(2);
        this.index = Integer.valueOf(event.getParameter().getValue().substring(1, 2));
    }

    private boolean isDataByte(byte data) {
        return !Character.isLetterOrDigit(data);
    }

    private boolean isSet(byte data, int pos) {
        return (data >> pos & 1) == 1;
    }

    public String getDisplayLine() {
        return this.displayLine;
    }

    public Event getEvent() {
        return this.event;
    }

    public boolean isPlayable() {
        return this.playable;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public boolean isCursorSelect() {
        return this.cursorSelect;
    }

    public boolean isPicture() {
        return this.picture;
    }

    @Override
    public int compareTo(Line o) {
        return this.getIndex().compareTo(o.getIndex());
    }

    public Integer getIndex() {
        return this.index;
    }
}

