/*
 * Decompiled with CFR 0.152.
 */
package io.theves.denon4j;

import io.theves.denon4j.Receiver;
import io.theves.denon4j.controls.Control;
import io.theves.denon4j.controls.InputSource;
import io.theves.denon4j.controls.Menu;
import io.theves.denon4j.controls.NetworkControl;
import io.theves.denon4j.controls.NetworkControlImpl;
import io.theves.denon4j.controls.Select;
import io.theves.denon4j.controls.SelectImpl;
import io.theves.denon4j.controls.Slider;
import io.theves.denon4j.controls.SliderImpl;
import io.theves.denon4j.controls.SurroundMode;
import io.theves.denon4j.controls.SwitchState;
import io.theves.denon4j.controls.Toggle;
import io.theves.denon4j.controls.ToggleImpl;
import io.theves.denon4j.controls.VideoSource;
import io.theves.denon4j.net.Command;
import io.theves.denon4j.net.EventDispatcher;
import io.theves.denon4j.net.Protocol;
import io.theves.denon4j.net.RequestCommand;
import io.theves.denon4j.net.Tcp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public class DenonReceiver
implements Receiver {
    private final EventDispatcher eventDispatcher;
    private final Protocol protocol;
    private final Collection<Control> controls;
    private ToggleImpl powerToggle;
    private SliderImpl masterSlider;
    private ToggleImpl mainZoneToggle;
    private ToggleImpl muteToggle;
    private SelectImpl<InputSource> selectInput;
    private SelectImpl<VideoSource> selectVideo;
    private NetworkControlImpl selectNet;
    private Menu menu;
    private SelectImpl<SurroundMode> selectSurround;

    public DenonReceiver(String host, int port) {
        this(new Tcp(host, port));
    }

    DenonReceiver(Protocol protocol) {
        this.protocol = Objects.requireNonNull(protocol);
        this.eventDispatcher = new EventDispatcher();
        this.controls = new ArrayList<Control>();
        this.protocol.setDispatcher(this.eventDispatcher);
        this.addControls(this.controls);
        this.addToDispatcher(this.controls);
    }

    private void addControls(Collection<? super Control> controls) {
        this.powerToggle = new ToggleImpl(this.protocol, "PW", SwitchState.ON, SwitchState.STANDBY);
        this.powerToggle.setName("Power Switch");
        this.powerToggle.init();
        controls.add(this.powerToggle);
        this.masterSlider = new SliderImpl(this.protocol, "MV", "UP", "DOWN");
        this.masterSlider.setName("Master Volume");
        this.masterSlider.init();
        controls.add(this.masterSlider);
        this.muteToggle = new ToggleImpl(this.protocol, "MU", SwitchState.ON, SwitchState.OFF);
        this.muteToggle.setName("Mute Toggle");
        this.muteToggle.init();
        controls.add(this.muteToggle);
        this.selectInput = new SelectImpl(this.protocol, "SI", (Enum[])InputSource.values());
        this.selectInput.setName("Select INPUT Source");
        this.selectInput.init();
        controls.add(this.selectInput);
        this.selectVideo = new SelectImpl(this.protocol, "SV", (Enum[])VideoSource.values());
        this.selectVideo.setName("Select VIDEO Source");
        this.selectVideo.init();
        controls.add(this.selectVideo);
        this.mainZoneToggle = new ToggleImpl(this.protocol, "ZM", SwitchState.ON, SwitchState.OFF);
        this.mainZoneToggle.setName("Main Zone Toggle");
        this.mainZoneToggle.init();
        controls.add(this.mainZoneToggle);
        this.selectNet = new NetworkControlImpl(this.protocol);
        this.selectNet.init();
        controls.add(this.selectNet);
        this.menu = new Menu(this.protocol);
        this.menu.init();
        controls.add(this.menu);
        this.selectSurround = new SelectImpl(this.protocol, "MS", (Enum[])SurroundMode.values());
        this.selectSurround.init();
        controls.add(this.selectSurround);
    }

    private void addToDispatcher(Collection<Control> controls) {
        controls.stream().forEach(this.eventDispatcher::addControl);
    }

    public Select<SurroundMode> surroundMode() {
        return this.selectSurround;
    }

    EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public Toggle power() {
        return this.powerToggle;
    }

    public Toggle mainZone() {
        return this.mainZoneToggle;
    }

    public Slider masterVolume() {
        return this.masterSlider;
    }

    public Toggle mute() {
        return this.muteToggle;
    }

    public Select<InputSource> input() {
        return this.selectInput;
    }

    public NetworkControl networkControl() {
        return this.selectNet;
    }

    public Select<VideoSource> video() {
        return this.selectVideo;
    }

    public Menu menu() {
        return this.menu;
    }

    @Override
    public String send(String command) {
        Command cmd = Command.createCommand(this.protocol, command);
        cmd.execute();
        if (cmd instanceof RequestCommand) {
            return ((RequestCommand)cmd).getReceived().getParameter().getValue();
        }
        return null;
    }

    @Override
    public Collection<Control> getControls() {
        return this.controls;
    }

    @Override
    public void close() {
        this.disconnect();
    }

    public void disconnect() {
        this.getControls().forEach(this.eventDispatcher::removeControl);
        this.getControls().forEach(Control::dispose);
        this.protocol.disconnect();
    }

    public void connect(int timeout) {
        this.protocol.establishConnection(timeout);
    }

    public boolean isConnected() {
        return this.protocol.isConnected();
    }
}

