/*
 * Decompiled with CFR 0.152.
 */
package io.theves.denon4j.net;

import io.theves.denon4j.net.Parameter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Objects;

public class Event {
    private final String prefix;
    private final Parameter parameter;
    private final LocalDateTime createdAt;
    private final byte[] raw;

    protected Event(byte[] raw, String prefix, Parameter parameter) {
        this.raw = Objects.requireNonNull(raw);
        this.prefix = Objects.requireNonNull(prefix);
        this.parameter = Objects.requireNonNull(parameter);
        this.createdAt = LocalDateTime.now();
    }

    public static Event create(String event) {
        return Event.create(event.getBytes(StandardCharsets.UTF_8));
    }

    public static Event create(byte[] raw) {
        String prefix = new String(raw, 0, 2, StandardCharsets.US_ASCII);
        String parameter = new String(raw, 2, raw.length - 2, StandardCharsets.UTF_8);
        return new Event(raw, prefix, Parameter.createParameter(parameter));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String toString() {
        return "Event{prefix='" + this.prefix + '\'' + ", parameter=" + this.parameter + ", createdAt=" + this.createdAt + '}';
    }
}

