/*
 * Decompiled with CFR 0.152.
 */
package io.theves.denon4j.controls;

import io.theves.denon4j.controls.AbstractControl;
import io.theves.denon4j.controls.Slider;
import io.theves.denon4j.net.Command;
import io.theves.denon4j.net.Event;
import io.theves.denon4j.net.Protocol;
import io.theves.denon4j.net.RequestCommand;
import io.theves.denon4j.net.SetCommand;

public class SliderImpl
extends AbstractControl
implements Slider {
    private final String up;
    private final String down;

    public SliderImpl(Protocol protocol, String prefix, String up, String down) {
        super(prefix, protocol);
        this.up = up;
        this.down = down;
    }

    @Override
    public void slideUp() {
        this.executeCommand(this.up);
    }

    private void executeCommand(String param) {
        Command.createCommand(this.protocol, this.prefix, param).execute();
    }

    @Override
    public void slideDown() {
        this.executeCommand(this.down);
    }

    @Override
    public String getValue() {
        RequestCommand command = Command.createRequestCommand(this.protocol, this.prefix);
        command.execute();
        return command.getReceived().getParameter().getValue();
    }

    @Override
    public void set(String value) {
        this.executeSetCommand(value);
    }

    private void executeSetCommand(String value) {
        SetCommand setCommand = Command.createSetCommand(this.protocol, this.prefix);
        setCommand.set(value);
        setCommand.execute();
    }

    @Override
    public void doHandle(Event event) {
    }

    @Override
    public boolean supports(Event event) {
        return this.getCommandPrefix().equals(event.getPrefix());
    }

    @Override
    protected void doInit() {
    }
}

