/*
 * Decompiled with CFR 0.152.
 */
package io.theves.denon4j.controls;

import io.theves.denon4j.controls.AbstractControl;
import io.theves.denon4j.controls.Select;
import io.theves.denon4j.net.Command;
import io.theves.denon4j.net.Event;
import io.theves.denon4j.net.Parameter;
import io.theves.denon4j.net.Protocol;
import io.theves.denon4j.net.RequestCommand;
import java.util.Objects;
import java.util.stream.Stream;

public class SelectImpl<S extends Enum>
extends AbstractControl
implements Select<S> {
    private final S[] params;

    public SelectImpl(Protocol protocol, String prefix, S[] params) {
        super(prefix, protocol);
        this.params = (Enum[])Objects.requireNonNull(params);
    }

    @Override
    public void select(S source) {
        Command.createCommand(this.protocol, this.prefix, ((Enum)source).toString()).execute();
    }

    @Override
    public S get() {
        RequestCommand command = Command.createRequestCommand(this.protocol, this.prefix);
        command.execute();
        Event received = command.getReceived();
        return this.findSource(received.getParameter());
    }

    private S findSource(Parameter state) {
        return (S)Stream.of(this.params).filter(e -> state.getValue().equals(e.toString())).findFirst().orElseThrow(IllegalStateException::new);
    }

    @Override
    protected void doHandle(Event event) {
    }

    @Override
    protected void doInit() {
    }
}

