/*
 * Decompiled with CFR 0.152.
 */
package io.theves.denon4j.controls;

import io.theves.denon4j.controls.DisplayInfo;
import io.theves.denon4j.controls.NetworkControl;
import io.theves.denon4j.controls.NetworkControls;
import io.theves.denon4j.controls.SelectImpl;
import io.theves.denon4j.net.Command;
import io.theves.denon4j.net.Event;
import io.theves.denon4j.net.Protocol;

public class NetworkControlImpl
extends SelectImpl<NetworkControls>
implements NetworkControl {
    private DisplayInfo mostRecentDisplayInfo;

    public NetworkControlImpl(Protocol protocol) {
        super(protocol, "NS", (Enum[])NetworkControls.values());
        this.setName("Network USB/AUDIO/IPOD Extended Control");
    }

    @Override
    public void doHandle(Event event) {
        if (this.isDisplayInfoEvent(event)) {
            if (this.mostRecentDisplayInfo == null || this.mostRecentDisplayInfo.isComplete()) {
                this.mostRecentDisplayInfo = new DisplayInfo();
            }
            this.mostRecentDisplayInfo.addEvent(event);
        }
    }

    @Override
    protected void doInit() {
    }

    private boolean isDisplayInfoEvent(Event event) {
        return event.getPrefix().startsWith("NS");
    }

    @Override
    public DisplayInfo getDisplay() {
        this.readOnscreenInfo();
        return this.mostRecentDisplayInfo;
    }

    private void readOnscreenInfo() {
        Command nse = Command.createCommand(this.protocol, this.prefix, "E");
        nse.execute();
        while (this.mostRecentDisplayInfo == null || !this.mostRecentDisplayInfo.isComplete()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

