/*
 * Decompiled with CFR 0.152.
 */
package io.theves.denon4j.controls;

import io.theves.denon4j.controls.Control;
import io.theves.denon4j.controls.NotYetInitializedException;
import io.theves.denon4j.net.AlreadyInitException;
import io.theves.denon4j.net.Event;
import io.theves.denon4j.net.Protocol;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractControl
implements Control {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String prefix;
    protected final Protocol protocol;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private String name;

    public AbstractControl(String prefix, Protocol protocol) {
        this.prefix = Objects.requireNonNull(prefix);
        this.protocol = protocol;
    }

    @Override
    public final void handle(Event event) {
        this.checkInitialized();
        this.doHandle(event);
        this.logger.debug("Handled event: {}", (Object)event);
    }

    protected void checkInitialized() {
        if (!this.initialized.get()) {
            throw new NotYetInitializedException(this);
        }
    }

    protected abstract void doHandle(Event var1);

    @Override
    public String getCommandPrefix() {
        return this.prefix;
    }

    @Override
    public final void init() {
        if (!this.initialized.compareAndSet(false, true)) {
            throw new AlreadyInitException("This control has already been initialized");
        }
        this.doInit();
        this.logger.debug("Control initialized: {}", (Object)this);
    }

    @Override
    public boolean isInitialized() {
        return this.initialized.get();
    }

    @Override
    public void dispose() {
        this.logger.debug("Control disposed: {}", (Object)this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean supports(Event event) {
        return this.getCommandPrefix().equals(event.getPrefix());
    }

    protected abstract void doInit();

    public String toString() {
        return "Control{prefix='" + this.prefix + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

