/*
 * Decompiled with CFR 0.152.
 */
package io.theves.denon4j;

import io.theves.denon4j.DenonReceiver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Cli {
    private List<String> args = new ArrayList<String>();

    public Cli(String[] args) {
        this.args.addAll(Arrays.asList(args));
    }

    public static void main(String[] args) {
        if (null == args || args.length != 2) {
            System.err.println("Try java -jar $/path/to/jar $host $port");
            Cli.quit(1);
        }
        Cli cli = new Cli(args);
        cli.interactiveMode();
        Cli.quit(0);
    }

    private static void quit(int status) {
        System.exit(status);
    }

    public void interactiveMode() {
        try (DenonReceiver avr = new DenonReceiver(this.args.get(0), Integer.parseInt(this.args.get(1)));){
            avr.connect(1000);
            System.out.println("Enter a command ('?' for help, 'q' for quit):");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            try {
                while (true) {
                    String input;
                    if ((input = this.readInput(reader)) == null) {
                        continue;
                    }
                    if ("?".equals(input)) {
                        this.printHelp();
                        continue;
                    }
                    if (!"q".equals(input)) {
                        String response;
                        if (input.length() <= 2 || (response = avr.send(input)) == null) continue;
                        System.out.println(response);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            System.out.println("...bye");
        }
    }

    private String readInput(BufferedReader reader) throws IOException {
        System.out.print("> ");
        return reader.readLine();
    }

    private void printHelp() {
        PrintWriter writer = new PrintWriter(System.out);
        writer.println();
        writer.println("The following options are available:");
        writer.println();
        writer.println("?\t\t\tPrints this help");
        writer.println("q\t\t\tQuits the program");
        writer.println("<cmd>\t\tExecutes a generic command e.g. PW?");
        writer.println("PW?\t\t\tReturns the power state");
        writer.println("PWON\t\tTurns power on");
        writer.println();
        writer.println("See the Denon AVR protocol for a full list of commands.");
        writer.flush();
    }
}

