/*
 * Decompiled with CFR 0.152.
 */
package io.thedocs.soyuz.validator;

import io.thedocs.soyuz.err.Err;
import io.thedocs.soyuz.err.Errors;
import io.thedocs.soyuz.validator.FluentValidatorBuilder;
import io.thedocs.soyuz.validator.FluentValidatorObjects;
import io.thedocs.soyuz.validator.Fv;
import io.thedocs.soyuz.validator.FvUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public interface FluentValidatorRule<R, V> {
    public Fv.Result validate(R var1, String var2, V var3);

    public static class Error<V> {
        private String code;
        private V value;

        public Error(String code, V value) {
            this.code = code;
            this.value = value;
        }

        public String getCode() {
            return this.code;
        }

        public V getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Error)) {
                return false;
            }
            Error other = (Error)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            V this$value = this.getValue();
            V other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Error;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            V $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "FluentValidatorRule.Error(code=" + this.getCode() + ", value=" + this.getValue() + ")";
        }
    }

    public static interface Base {

        public static class Validator<R, V>
        implements FluentValidatorRule<R, V> {
            private Fv.Validator<V> validator;

            public Validator(Fv.Validator<V> validator) {
                this.validator = validator;
            }

            @Override
            public Fv.Result validate(R rootObject, String property, V value) {
                Fv.Result<V> result = this.validator.validate(value);
                if (result.isOk()) {
                    return result;
                }
                return Fv.Result.failure(rootObject, FluentValidatorObjects.ErrorUtils.addParentProperty(result.getErrors(), property));
            }
        }

        public static class Custom<R, V>
        implements FluentValidatorRule<R, V> {
            private FluentValidatorObjects.CustomValidator.Simple<R, V> customSimple;
            private FluentValidatorObjects.CustomValidator.WithBuilder<R, V> customWithBuilder;

            public Custom(FluentValidatorObjects.CustomValidator.Simple<R, V> customSimple) {
                this.customSimple = customSimple;
            }

            public Custom(FluentValidatorObjects.CustomValidator.WithBuilder<R, V> customWithBuilder) {
                this.customWithBuilder = customWithBuilder;
            }

            @Override
            public Fv.Result validate(R rootObject, String property, V value) {
                Fv.CustomResult result = null;
                if (this.customSimple != null) {
                    result = this.customSimple.validate(rootObject, value);
                } else if (this.customWithBuilder != null) {
                    result = this.customWithBuilder.validate(rootObject, value, new FluentValidatorBuilder());
                }
                if (result == null) {
                    return null;
                }
                return this.toFvResult(result, rootObject, property, value);
            }

            private Fv.Result toFvResult(Fv.CustomResult result, R rootObject, String property, V value) {
                if (result.isOk()) {
                    return Fv.Result.success(rootObject);
                }
                Errors errorsSource = result.getErrors();
                ArrayList<Err> errors = new ArrayList<Err>(errorsSource.get().size());
                for (Err e : errorsSource) {
                    errors.add(Err.field((String)FluentValidatorObjects.PropertyUtils.mix(property, e.getField())).code(e.getCode()).value(e.hasField() ? e.getValue() : value).params(e.getParams()).build());
                }
                return Fv.Result.failure(rootObject, Errors.reject(errors));
            }
        }

        public static class NotEqFunction<R, V>
        implements FluentValidatorRule<R, V> {
            private Function<V, Boolean> notEqFunction;

            public NotEqFunction(Function<V, Boolean> notEqFunction) {
                this.notEqFunction = notEqFunction;
            }

            @Override
            public Fv.Result validate(R rootObject, String property, V value) {
                return null;
            }
        }

        public static class NotEq<R, V>
        implements FluentValidatorRule<R, V> {
            private V value;

            public NotEq(V value) {
                this.value = value;
            }

            @Override
            public Fv.Result validate(R rootObject, String property, V value) {
                return null;
            }
        }

        public static class EqFunction<R, V>
        extends AbstractRule<R, V> {
            private Function<V, Boolean> eqFunction;

            public EqFunction(Function<V, Boolean> eqFunction) {
                this.eqFunction = eqFunction;
            }

            @Override
            protected String getCode() {
                return "notEq";
            }

            @Override
            protected boolean isValid(R rootObject, V value) {
                return this.eqFunction.apply(value);
            }
        }

        public static class Eq<R, V>
        extends AbstractRule<R, V> {
            private V value;

            public Eq(V value) {
                this.value = value;
            }

            @Override
            protected String getCode() {
                return "notEq";
            }

            @Override
            protected boolean isValid(R rootObject, V value) {
                return value != null && value.equals(this.value);
            }
        }
    }

    public static interface Coll {

        public static class ItemValidator<R, V>
        implements FluentValidatorRule<R, Collection<V>> {
            private Fv.Validator<V> validator;

            public ItemValidator(Fv.Validator<V> validator) {
                this.validator = validator;
            }

            @Override
            public Fv.Result validate(R rootObject, String property, Collection<V> value) {
                if (value == null) {
                    return Fv.Result.success();
                }
                Errors errors = Errors.ok();
                int index = 0;
                for (V item : value) {
                    Fv.Result<V> result = this.validator.validate(item);
                    if (result.hasErrors()) {
                        errors.add(FluentValidatorObjects.ErrorUtils.addParentProperty(result.getErrors(), property + "[" + index + "]"));
                    }
                    ++index;
                }
                if (errors.isOk()) {
                    return Fv.Result.success();
                }
                return Fv.Result.failure(rootObject, errors);
            }
        }

        public static class LessThan<R, V>
        extends AbstractRule<R, Collection<V>> {
            private int size;

            public LessThan(int size) {
                this.size = size;
            }

            @Override
            protected String getCode() {
                return "lessThan";
            }

            @Override
            protected boolean isValid(R rootObject, Collection<V> value) {
                return value == null || value.size() < this.size;
            }

            @Override
            public Map<String, Object> getErrorParams() {
                return FvUtils.to.map("criterion", this.size);
            }
        }

        public static class LessOrEqual<R, V>
        extends AbstractRule<R, Collection<V>> {
            private int size;

            public LessOrEqual(int size) {
                this.size = size;
            }

            @Override
            protected String getCode() {
                return "lessOrEqual";
            }

            @Override
            protected boolean isValid(R rootObject, Collection<V> value) {
                return value == null || value.size() <= this.size;
            }

            @Override
            public Map<String, Object> getErrorParams() {
                return FvUtils.to.map("criterion", this.size);
            }
        }

        public static class GreaterThan<R, V>
        extends AbstractRule<R, Collection<V>> {
            private int size;

            public GreaterThan(int size) {
                this.size = size;
            }

            @Override
            protected String getCode() {
                return "greaterThan";
            }

            @Override
            protected boolean isValid(R rootObject, Collection<V> value) {
                return value != null && value.size() > this.size;
            }

            @Override
            public Map<String, Object> getErrorParams() {
                return FvUtils.to.map("criterion", this.size);
            }
        }

        public static class GreaterOrEqual<R, V>
        extends AbstractRule<R, Collection<V>> {
            private int size;

            public GreaterOrEqual(int size) {
                this.size = size;
            }

            @Override
            protected String getCode() {
                return "greaterOrEqual";
            }

            @Override
            protected boolean isValid(R rootObject, Collection<V> value) {
                return value != null && value.size() >= this.size;
            }

            @Override
            public Map<String, Object> getErrorParams() {
                return FvUtils.to.map("criterion", this.size);
            }
        }

        public static class NotEmpty<R, V>
        extends AbstractRule<R, Collection<V>> {
            @Override
            protected String getCode() {
                return "notEmpty";
            }

            @Override
            protected boolean isValid(R rootObject, Collection<V> value) {
                return value != null && !value.isEmpty();
            }
        }
    }

    public static interface Obj {

        public static class NotNull<R, V>
        extends AbstractRule<R, V> {
            @Override
            protected String getCode() {
                return "notNull";
            }

            @Override
            protected boolean isValid(R rootObject, V value) {
                return value != null;
            }
        }
    }

    public static interface D {

        public static class Between<R, V>
        extends AbstractRule<R, V> {
            private Supplier<V> afterSupplier;
            private Supplier<V> beforeSupplier;
            private Comparator<V> comparator;

            public Between(Supplier<V> afterSupplier, Supplier<V> beforeSupplier, Comparator<V> comparator) {
                this.afterSupplier = afterSupplier;
                this.beforeSupplier = beforeSupplier;
                this.comparator = comparator;
            }

            @Override
            protected String getCode() {
                return "between";
            }

            @Override
            protected boolean isValid(R rootObject, V value) {
                if (value == null) {
                    return true;
                }
                return this.comparator.compare(value, this.afterSupplier.get()) > 0 && this.comparator.compare(value, this.beforeSupplier.get()) < 0;
            }
        }

        public static class GreaterOrEqual<R, V>
        extends AbstractRule<R, V> {
            private Supplier<V> dateSupplier;
            private Comparator<V> comparator;

            public GreaterOrEqual(Supplier<V> dateSupplier, Comparator<V> comparator) {
                this.dateSupplier = dateSupplier;
                this.comparator = comparator;
            }

            @Override
            protected String getCode() {
                return "greaterOrEqual";
            }

            @Override
            protected boolean isValid(R rootObject, V value) {
                return value == null || this.comparator.compare(value, this.dateSupplier.get()) >= 0;
            }
        }

        public static class GreaterThan<R, V>
        extends AbstractRule<R, V> {
            private Supplier<V> dateSupplier;
            private Comparator<V> comparator;

            public GreaterThan(Supplier<V> dateSupplier, Comparator<V> comparator) {
                this.dateSupplier = dateSupplier;
                this.comparator = comparator;
            }

            @Override
            protected String getCode() {
                return "greaterThan";
            }

            @Override
            protected boolean isValid(R rootObject, V value) {
                return value == null || this.comparator.compare(value, this.dateSupplier.get()) > 0;
            }
        }

        public static class LessOrEqual<R, V>
        extends AbstractRule<R, V> {
            private Supplier<V> dateSupplier;
            private Comparator<V> comparator;

            public LessOrEqual(Supplier<V> dateSupplier, Comparator<V> comparator) {
                this.dateSupplier = dateSupplier;
                this.comparator = comparator;
            }

            @Override
            protected String getCode() {
                return "lessOrEqual";
            }

            @Override
            protected boolean isValid(R rootObject, V value) {
                return value == null || this.comparator.compare(value, this.dateSupplier.get()) <= 0;
            }
        }

        public static class LessThan<R, V>
        extends AbstractRule<R, V> {
            private Supplier<V> dateSupplier;
            private Comparator<V> comparator;

            public LessThan(Supplier<V> dateSupplier, Comparator<V> comparator) {
                this.dateSupplier = dateSupplier;
                this.comparator = comparator;
            }

            @Override
            protected String getCode() {
                return "lessThan";
            }

            @Override
            protected boolean isValid(R rootObject, V value) {
                return value == null || this.comparator.compare(value, this.dateSupplier.get()) < 0;
            }
        }
    }

    public static interface N {

        public static class LessThan<R, V extends Number>
        extends AbstractRule<R, V> {
            private V value;

            public LessThan(V value) {
                this.value = value;
            }

            @Override
            protected String getCode() {
                return "lessThan";
            }

            @Override
            protected boolean isValid(R rootObject, V value) {
                return value == null || ((Comparable)value).compareTo(this.value) < 0;
            }

            @Override
            public Map<String, Object> getErrorParams() {
                return FvUtils.to.map("criterion", this.value);
            }
        }

        public static class LessOrEqual<R, V extends Number>
        extends AbstractRule<R, V> {
            private V value;

            public LessOrEqual(V value) {
                this.value = value;
            }

            @Override
            protected String getCode() {
                return "lessOrEqual";
            }

            @Override
            protected boolean isValid(R rootObject, V value) {
                return value == null || ((Comparable)value).compareTo(this.value) <= 0;
            }

            @Override
            public Map<String, Object> getErrorParams() {
                return FvUtils.to.map("criterion", this.value);
            }
        }

        public static class GreaterThan<R, V extends Number>
        extends AbstractRule<R, V> {
            private V value;

            public GreaterThan(V value) {
                this.value = value;
            }

            @Override
            protected String getCode() {
                return "greaterThan";
            }

            @Override
            protected boolean isValid(R rootObject, V value) {
                return value == null || ((Comparable)value).compareTo(this.value) > 0;
            }

            @Override
            public Map<String, Object> getErrorParams() {
                return FvUtils.to.map("criterion", this.value);
            }
        }

        public static class GreaterOrEqual<R, V extends Number>
        extends AbstractRule<R, V> {
            private V value;

            public GreaterOrEqual(V value) {
                this.value = value;
            }

            @Override
            protected String getCode() {
                return "greaterOrEqual";
            }

            @Override
            protected boolean isValid(R rootObject, V value) {
                return value == null || ((Comparable)value).compareTo(this.value) >= 0;
            }

            @Override
            public Map<String, Object> getErrorParams() {
                return FvUtils.to.map("criterion", this.value);
            }
        }
    }

    public static interface Int {

        public static class LessThan<R>
        extends AbstractRule<R, Integer> {
            private int value;

            public LessThan(int value) {
                this.value = value;
            }

            @Override
            protected String getCode() {
                return "lessThan";
            }

            @Override
            protected boolean isValid(R rootObject, Integer value) {
                return value != null && value < this.value;
            }

            @Override
            public Map<String, Object> getErrorParams() {
                return FvUtils.to.map("criterion", this.value);
            }
        }

        public static class LessOrEqual<R>
        extends AbstractRule<R, Integer> {
            private int value;

            public LessOrEqual(int value) {
                this.value = value;
            }

            @Override
            protected String getCode() {
                return "lessOrEqual";
            }

            @Override
            protected boolean isValid(R rootObject, Integer value) {
                return value != null && value <= this.value;
            }

            @Override
            public Map<String, Object> getErrorParams() {
                return FvUtils.to.map("criterion", this.value);
            }
        }

        public static class GreaterThan<R>
        extends AbstractRule<R, Integer> {
            private int value;

            public GreaterThan(int value) {
                this.value = value;
            }

            @Override
            protected String getCode() {
                return "greaterThan";
            }

            @Override
            protected boolean isValid(R rootObject, Integer value) {
                return value != null && value > this.value;
            }

            @Override
            public Map<String, Object> getErrorParams() {
                return FvUtils.to.map("criterion", this.value);
            }
        }

        public static class GreaterOrEqual<R>
        extends AbstractRule<R, Integer> {
            private int value;

            public GreaterOrEqual(int value) {
                this.value = value;
            }

            @Override
            protected String getCode() {
                return "greaterOrEqual";
            }

            @Override
            protected boolean isValid(R rootObject, Integer value) {
                return value != null && value >= this.value;
            }

            @Override
            public Map<String, Object> getErrorParams() {
                return FvUtils.to.map("criterion", this.value);
            }
        }
    }

    public static interface Str {

        public static class Matches<R>
        extends AbstractRule<R, String> {
            private Pattern pattern;

            public Matches(Pattern pattern) {
                this.pattern = pattern;
            }

            @Override
            protected String getCode() {
                return "matches";
            }

            @Override
            protected boolean isValid(R rootObject, String value) {
                return value == null || this.pattern.matcher(value).matches();
            }
        }

        public static class LessThan<R>
        extends AbstractRule<R, String> {
            private int size;

            public LessThan(int size) {
                this.size = size;
            }

            @Override
            protected String getCode() {
                return "lessThan";
            }

            @Override
            protected boolean isValid(R rootObject, String value) {
                return value == null || value.length() < this.size;
            }

            @Override
            public Map<String, Object> getErrorParams() {
                return FvUtils.to.map("criterion", this.size);
            }
        }

        public static class LessOrEqual<R>
        extends AbstractRule<R, String> {
            private int size;

            public LessOrEqual(int size) {
                this.size = size;
            }

            @Override
            protected String getCode() {
                return "lessOrEqual";
            }

            @Override
            protected boolean isValid(R rootObject, String value) {
                return value == null || value.length() <= this.size;
            }

            @Override
            public Map<String, Object> getErrorParams() {
                return FvUtils.to.map("criterion", this.size);
            }
        }

        public static class GreaterThan<R>
        extends AbstractRule<R, String> {
            private int size;

            public GreaterThan(int size) {
                this.size = size;
            }

            @Override
            protected String getCode() {
                return "greaterThan";
            }

            @Override
            protected boolean isValid(R rootObject, String value) {
                return value != null && value.length() > this.size;
            }

            @Override
            public Map<String, Object> getErrorParams() {
                return FvUtils.to.map("criterion", this.size);
            }
        }

        public static class GreaterOrEqual<R>
        extends AbstractRule<R, String> {
            private int size;

            public GreaterOrEqual(int size) {
                this.size = size;
            }

            @Override
            protected String getCode() {
                return "greaterOrEqual";
            }

            @Override
            protected boolean isValid(R rootObject, String value) {
                return value != null && value.length() >= this.size;
            }

            @Override
            public Map<String, Object> getErrorParams() {
                return FvUtils.to.map("criterion", this.size);
            }
        }

        public static class IsFloat<R>
        extends AbstractRule<R, String> {
            @Override
            protected String getCode() {
                return "isFloat";
            }

            @Override
            protected boolean isValid(R rootObject, String value) {
                if (value == null) {
                    return false;
                }
                try {
                    Float.valueOf(value);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }

        public static class IsDouble<R>
        extends AbstractRule<R, String> {
            @Override
            protected String getCode() {
                return "isDouble";
            }

            @Override
            protected boolean isValid(R rootObject, String value) {
                if (value == null) {
                    return false;
                }
                try {
                    Double.valueOf(value);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }

        public static class IsLong<R>
        extends AbstractRule<R, String> {
            @Override
            protected String getCode() {
                return "isLong";
            }

            @Override
            protected boolean isValid(R rootObject, String value) {
                if (value == null) {
                    return false;
                }
                try {
                    Long.valueOf(value);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }

        public static class IsInteger<R>
        extends AbstractRule<R, String> {
            @Override
            protected String getCode() {
                return "isInteger";
            }

            @Override
            protected boolean isValid(R rootObject, String value) {
                if (value == null) {
                    return false;
                }
                try {
                    Integer.valueOf(value);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }

        public static class IsShort<R>
        extends AbstractRule<R, String> {
            @Override
            protected String getCode() {
                return "isShort";
            }

            @Override
            protected boolean isValid(R rootObject, String value) {
                if (value == null) {
                    return false;
                }
                try {
                    Short.valueOf(value);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }

        public static class IsByte<R>
        extends AbstractRule<R, String> {
            @Override
            protected String getCode() {
                return "isByte";
            }

            @Override
            protected boolean isValid(R rootObject, String value) {
                if (value == null) {
                    return false;
                }
                try {
                    Byte.valueOf(value);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }

        public static class IsBoolean<R>
        extends AbstractRule<R, String> {
            @Override
            protected String getCode() {
                return "isBoolean";
            }

            @Override
            protected boolean isValid(R rootObject, String value) {
                return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"));
            }
        }

        public static class Email<R>
        extends AbstractRule<R, String> {
            private static final Pattern MAIL_PATTERN = Pattern.compile("^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,20}$");

            @Override
            protected String getCode() {
                return "email";
            }

            @Override
            protected boolean isValid(R rootObject, String value) {
                return value == null || MAIL_PATTERN.matcher(value).matches();
            }
        }

        public static class Url<R>
        extends AbstractRule<R, String> {
            @Override
            protected String getCode() {
                return "url";
            }

            @Override
            protected boolean isValid(R rootObject, String value) {
                return value == null || this.isUrl(value);
            }

            private boolean isUrl(String value) {
                try {
                    new URL(value);
                    return true;
                }
                catch (MalformedURLException e) {
                    return false;
                }
            }
        }

        public static class NotBlank<R>
        extends AbstractRule<R, String> {
            @Override
            protected String getCode() {
                return "notBlank";
            }

            @Override
            protected boolean isValid(R rootObject, String value) {
                return value != null && value.trim().length() > 0;
            }
        }

        public static class NotEmpty<R>
        extends AbstractRule<R, String> {
            @Override
            protected String getCode() {
                return "notEmpty";
            }

            @Override
            protected boolean isValid(R rootObject, String value) {
                return value != null && value.length() > 0;
            }
        }
    }

    public static abstract class AbstractRule<R, V>
    implements FluentValidatorRule<R, V> {
        @Override
        public Fv.Result validate(R rootObject, String property, V value) {
            if (!this.isValid(rootObject, value)) {
                return Fv.Result.failure(rootObject, Err.field((String)property).code(this.getCode()).value(value).params(this.getErrorParams()).build());
            }
            return null;
        }

        @Nullable
        public Map<String, Object> getErrorParams() {
            return null;
        }

        protected abstract String getCode();

        protected abstract boolean isValid(R var1, V var2);
    }
}

