/*
 * Decompiled with CFR 0.152.
 */
package io.thedocs.soyuz.validator;

import io.thedocs.soyuz.err.Err;
import io.thedocs.soyuz.err.Errors;
import io.thedocs.soyuz.validator.FluentValidatorBuilder;
import java.beans.ConstructorProperties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Fv {
    public static <T> FluentValidatorBuilder<T> of(Class<T> clazz) {
        return new FluentValidatorBuilder();
    }

    public static <T> FluentValidatorBuilder<T> of(String property, Class<T> clazz) {
        return new FluentValidatorBuilder(property);
    }

    public static class BeanValidationException
    extends RuntimeException {
        private Object rootObject;
        private Errors errors;

        public BeanValidationException(Object rootObject, Errors errors) {
            super("{root=" + rootObject + ", errors=" + errors + "}");
            this.rootObject = rootObject;
            this.errors = errors;
        }

        public BeanValidationException(Object rootObject, Err error) {
            this(rootObject, Errors.reject((Err[])new Err[]{error}));
        }

        public Object getRootObject() {
            return this.rootObject;
        }

        public Errors getErrors() {
            return this.errors;
        }

        @Override
        public String toString() {
            return "Fv.BeanValidationException(rootObject=" + this.getRootObject() + ", errors=" + this.getErrors() + ")";
        }
    }

    public static class Result<R> {
        private static final Result SUCCESS = new Result<Object>(null, Errors.ok());
        private R rootObject;
        private Errors errors;

        private Result(R rootObject, Errors errors) {
            this.rootObject = rootObject;
            this.errors = errors;
        }

        public boolean isOk() {
            return this.errors.isOk();
        }

        public boolean hasErrors() {
            return this.errors.hasErrors();
        }

        public R getRootObject() {
            return this.rootObject;
        }

        public Errors getErrors() {
            return this.errors;
        }

        public static Result success() {
            return SUCCESS;
        }

        public static <R> Result<R> success(R rootObject) {
            return new Result<R>(rootObject, Errors.ok());
        }

        public static <R> Result<R> failure(R rootObject, Err error) {
            return new Result<R>(rootObject, Errors.reject((Err[])new Err[]{error}));
        }

        public static <R> Result<R> failure(R rootObject, Errors errors) {
            return new Result<R>(rootObject, errors);
        }

        public void ifHasErrorsThrowAnException() {
            if (this.hasErrors()) {
                throw new BeanValidationException(this.rootObject, this.errors);
            }
        }

        public void ifHasErrorsThrowAnExceptionOr(Runnable runnable) {
            this.ifHasErrorsThrowAnException();
            runnable.run();
        }

        public void ifHasErrorsThrowAnExceptionOr(Consumer<R> consumer) {
            this.ifHasErrorsThrowAnException();
            consumer.accept(this.rootObject);
        }

        public <T> T ifHasErrorsThrowAnExceptionOr(Supplier<T> supplier) {
            this.ifHasErrorsThrowAnException();
            return supplier.get();
        }

        public <T> T ifHasErrorsThrowAnExceptionOr(Function<R, T> function) {
            this.ifHasErrorsThrowAnException();
            return function.apply(this.rootObject);
        }

        public String toString() {
            return "Fv.Result(rootObject=" + this.getRootObject() + ", errors=" + this.getErrors() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            R this$rootObject = this.getRootObject();
            R other$rootObject = other.getRootObject();
            if (this$rootObject == null ? other$rootObject != null : !this$rootObject.equals(other$rootObject)) {
                return false;
            }
            Errors this$errors = this.getErrors();
            Errors other$errors = other.getErrors();
            return !(this$errors == null ? other$errors != null : !this$errors.equals(other$errors));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            R $rootObject = this.getRootObject();
            result = result * 59 + ($rootObject == null ? 43 : $rootObject.hashCode());
            Errors $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : $errors.hashCode());
            return result;
        }
    }

    public static class CustomResult {
        private Errors errors;

        public boolean isOk() {
            return this.errors.isOk();
        }

        public boolean hasErrors() {
            return this.errors.hasErrors();
        }

        public static CustomResult success() {
            return new CustomResult(Errors.ok());
        }

        public static CustomResult failure(String code) {
            return CustomResult.failure(Err.code((String)code).build());
        }

        public static CustomResult failure(Err error) {
            return new CustomResult(Errors.reject((Err[])new Err[]{error}));
        }

        public static CustomResult failure(Errors errors) {
            return new CustomResult(errors);
        }

        public static CustomResult from(Result result) {
            if (result.isOk()) {
                return CustomResult.success();
            }
            return CustomResult.failure(result.getErrors());
        }

        public Errors getErrors() {
            return this.errors;
        }

        @ConstructorProperties(value={"errors"})
        private CustomResult(Errors errors) {
            this.errors = errors;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomResult)) {
                return false;
            }
            CustomResult other = (CustomResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Errors this$errors = this.getErrors();
            Errors other$errors = other.getErrors();
            return !(this$errors == null ? other$errors != null : !this$errors.equals(other$errors));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CustomResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Errors $errors = this.getErrors();
            result = result * 59 + ($errors == null ? 43 : $errors.hashCode());
            return result;
        }

        public String toString() {
            return "Fv.CustomResult(errors=" + this.getErrors() + ")";
        }
    }

    public static interface Validator<T> {
        public Result<T> validate(T var1);
    }
}

