/*
 * Decompiled with CFR 0.152.
 */
package io.thedocs.soyuz.validator;

import io.thedocs.soyuz.err.Errors;
import io.thedocs.soyuz.validator.FluentValidatorBuilder;
import io.thedocs.soyuz.validator.Fv;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;

public class FluentValidatorImpl<R>
implements Fv.Validator<R> {
    private static final PropertyUtilsBean PROPERTY_UTILS_BEAN = BeanUtilsBean.getInstance().getPropertyUtils();
    private List<FluentValidatorBuilder.ValidationDataWithProperties> validationData = new ArrayList<FluentValidatorBuilder.ValidationDataWithProperties>();

    public FluentValidatorImpl(List<FluentValidatorBuilder.ValidationDataWithProperties> validationData) {
        this.validationData = validationData;
    }

    public List<FluentValidatorBuilder.ValidationDataWithProperties> getValidationData() {
        return this.validationData;
    }

    @Override
    public Fv.Result<R> validate(R rootObject) {
        Errors errors = Errors.ok();
        for (FluentValidatorBuilder.ValidationDataWithProperties validationDataWithProperties : this.validationData) {
            String property = validationDataWithProperties.getProperty();
            Object value = this.getPropertyValue(rootObject, property);
            Fv.Result result = validationDataWithProperties.getData().validate(rootObject, property, value);
            if (result == null) continue;
            errors.add(result.getErrors());
        }
        return Fv.Result.failure(rootObject, errors);
    }

    private Object getPropertyValue(R o, String property) {
        try {
            if (o == null) {
                return null;
            }
            if (property == null) {
                return o;
            }
            return PROPERTY_UTILS_BEAN.getNestedProperty(o, property);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "FluentValidatorImpl(validationData=" + this.getValidationData() + ")";
    }
}

