/*
 * Decompiled with CFR 0.152.
 */
package io.thedocs.soyuz.validator.processor;

import io.thedocs.soyuz.err.AnswerOrErrors;
import io.thedocs.soyuz.err.Errors;
import io.thedocs.soyuz.to;
import io.thedocs.soyuz.validator.Fv;
import io.thedocs.soyuz.validator.processor.FvValidatableI;
import io.thedocs.soyuz.validator.processor.FvValidateComponentI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

public class FvValidatorsProcessor {
    private Map<Class<? extends FvValidatableI>, FvValidateComponentI<? extends FvValidatableI>> validators;

    public FvValidatorsProcessor(List<FvValidateComponentI<? extends FvValidatableI>> validators) {
        this.validators = to.map(validators, i -> i.getRequestType());
    }

    public AnswerOrErrors<?> process(FvValidatableI request, Runnable command) {
        return this.process(null, request, command);
    }

    public AnswerOrErrors<?> process(@Nullable Class<?> validatorClass, FvValidatableI request, Runnable command) {
        return this.process(validatorClass, request, () -> {
            command.run();
            return Void.TYPE;
        });
    }

    public <V> AnswerOrErrors<V> process(FvValidatableI request, Callable<V> command) {
        return this.process(null, request, command);
    }

    public <V> AnswerOrErrors<V> process(FvValidatableI request, AnswerOrErrorsCallable<V> command) {
        return this.process((Class<?>)null, request, command);
    }

    public <V> AnswerOrErrors<V> process(@Nullable Class<?> validatorClass, FvValidatableI request, Callable<V> command) {
        return this.process(validatorClass, request, () -> AnswerOrErrors.ok(command.call()));
    }

    public <V> AnswerOrErrors<V> process(@Nullable Class<?> validatorClass, FvValidatableI request, AnswerOrErrorsCallable<V> command) {
        FvValidateComponentI<? extends FvValidatableI> validator = this.validators.get(request.getClass());
        if (validator == null) {
            throw new RuntimeException("Validator for type [" + request.getClass().getSimpleName() + "] not supported!  Cannot process request");
        }
        if (validatorClass != null && validator.getClass() != validatorClass) {
            throw new RuntimeException("Invalid validator class for type [" + request.getClass().getSimpleName() + "]. Expected: " + validatorClass + ", real: " + validator.getClass() + ". Cannot process request");
        }
        Fv.Result result = validator.get().validate((Object)request);
        if (result.hasErrors()) {
            return AnswerOrErrors.failure((Errors)result.getErrors());
        }
        return (AnswerOrErrors)to.or(command.call(), AnswerOrErrors::ok);
    }

    public static interface AnswerOrErrorsCallable<V>
    extends Callable<AnswerOrErrors<V>> {
    }
}

