/*
 * Decompiled with CFR 0.152.
 */
package io.thedocs.soyuz.log;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerEvents {
    private static final Object[] EMPTY_PARAMS = new Object[0];
    private Logger log;

    public static LoggerEvents getInstance(Logger logger) {
        return new LoggerEvents(logger);
    }

    public static LoggerEvents getInstance(Class clazz) {
        return new LoggerEvents(LoggerFactory.getLogger((Class)clazz));
    }

    private LoggerEvents(Logger logger) {
        this.log = logger;
    }

    public Logger getLog() {
        return this.log;
    }

    public void trace(String event) {
        this.trace(event, null);
    }

    public void trace(String event, Map params) {
        this.log.trace(this.toLogMessage(event, params), this.toLogParams(params));
    }

    public void trace(String event, Map debugContext, Map params) {
        this.trace(event, this.joinContexts(debugContext, params));
    }

    public void debug(String event) {
        this.debug(event, null);
    }

    public void debug(String event, Map params) {
        this.log.debug(this.toLogMessage(event, params), this.toLogParams(params));
    }

    public void debug(String event, Map debugContext, Map params) {
        this.debug(event, this.joinContexts(debugContext, params));
    }

    public void info(String event) {
        this.info(event, null);
    }

    public void info(String event, Map params) {
        this.log.info(this.toLogMessage(event, params), this.toLogParams(params));
    }

    public void info(String event, Map debugContext, Map params) {
        this.info(event, this.joinContexts(debugContext, params));
    }

    public void warn(String event) {
        this.warn(event, (Map)null);
    }

    public void warn(String event, Throwable throwable) {
        this.log.warn(event, throwable);
    }

    public void warn(String event, Map params) {
        this.log.warn(this.toLogMessage(event, params), this.toLogParams(params));
    }

    public void warn(String event, Map debugContext, Map params) {
        this.warn(event, this.joinContexts(debugContext, params));
    }

    public void warn(String event, Map params, Throwable throwable) {
        this.log.warn(event + ": " + params.toString(), throwable);
    }

    public void error(String event) {
        this.error(event, (Map)null);
    }

    public void error(String event, Throwable throwable) {
        this.log.error(event, throwable);
    }

    public void error(String event, Map params) {
        this.log.error(this.toLogMessage(event, params), this.toLogParams(params));
    }

    public void error(String event, Map debugContext, Map params) {
        this.error(event, this.joinContexts(debugContext, params));
    }

    public void error(String event, Map params, Throwable throwable) {
        this.log.error(event + ": " + params.toString(), throwable);
    }

    public boolean isTraceEnabled() {
        return this.log.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    private String toLogMessage(String event, Map params) {
        if (params == null) {
            return event;
        }
        return event + ": {}";
    }

    private Object[] toLogParams(Map params) {
        if (params == null) {
            return EMPTY_PARAMS;
        }
        return new Object[]{params};
    }

    private Map joinContexts(Map debugContext, Map params) {
        HashMap answer = new HashMap(debugContext);
        answer.putAll(params);
        return answer;
    }
}

