/*
 * Decompiled with CFR 0.152.
 */
package io.thedocs.soyuz.err;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.thedocs.soyuz.err.Err;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class Errors
implements Iterable<Err> {
    private List<Err> errors;

    private Errors(List<Err> errors) {
        this.errors = errors;
    }

    public Errors add(Errors errors) {
        if (errors != null) {
            this.add(errors.get());
        }
        return this;
    }

    public Errors add(Err ... errors) {
        if (errors != null) {
            this.add(Arrays.asList(errors));
        }
        return this;
    }

    public Errors add(Collection<Err> errors) {
        if (errors != null) {
            this.errors.addAll(errors);
        }
        return this;
    }

    @JsonIgnore
    public boolean isOk() {
        return !this.hasErrors();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public List<Err> get() {
        return this.errors;
    }

    @JsonProperty(value="global")
    public List<Err> getGlobalErrors() {
        return this.errors.stream().filter(Err::isGlobalScope).collect(Collectors.toList());
    }

    @JsonProperty(value="fields")
    public List<Err> getFieldErrors() {
        return this.errors.stream().filter(Err::isFieldScope).collect(Collectors.toList());
    }

    public static Errors ok() {
        return new Errors(new ArrayList<Err>());
    }

    public static Errors reject(Err ... errors) {
        ArrayList<Err> answer = new ArrayList<Err>(errors.length);
        Collections.addAll(answer, errors);
        return new Errors(answer);
    }

    public static Errors reject(Collection<Err> errors) {
        ArrayList<Err> answer = new ArrayList<Err>();
        answer.addAll(errors);
        return new Errors(answer);
    }

    @Override
    public Iterator<Err> iterator() {
        return this.errors.iterator();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Errors)) {
            return false;
        }
        Errors other = (Errors)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Err> this$errors = this.errors;
        List<Err> other$errors = other.errors;
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Errors;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Err> $errors = this.errors;
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    public String toString() {
        return "Errors(errors=" + this.errors + ")";
    }
}

