/*
 * Decompiled with CFR 0.152.
 */
package io.thedocs.soyuz.err;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import javax.annotation.Nullable;

public class Err<V> {
    @Nullable
    private String field;
    private String code;
    @Nullable
    private String message;
    @Nullable
    private V value;
    @Nullable
    private Map<String, Object> params;

    @JsonIgnore
    public boolean isGlobalScope() {
        return this.field == null;
    }

    @JsonIgnore
    public boolean isFieldScope() {
        return this.field != null;
    }

    public static <K> ErrBuilder<K> builder() {
        return new ErrBuilder();
    }

    private Err() {
    }

    private Err(String field, String code, String message, V value, Map<String, Object> params) {
        this.field = field;
        this.code = code;
        this.message = message;
        this.value = value;
        this.params = params;
    }

    public ErrBuilder<V> toBuilder() {
        return Err.builder().field(this.field).code(this.code).message(this.message).value(this.value).params(this.params);
    }

    public boolean hasField() {
        return this.field != null;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean hasParams() {
        return this.params != null;
    }

    public static <V> ErrBuilder<V> code(Code code) {
        return Err.builder().code(code);
    }

    public static <V> ErrBuilder<V> code(String code) {
        return Err.builder().code(code);
    }

    public static <V> ErrBuilder<V> field(String field) {
        return Err.builder().field(field);
    }

    public static <V> ErrBuilder<V> message(String message) {
        return Err.builder().message(message);
    }

    @Nullable
    public String getField() {
        return this.field;
    }

    public String getCode() {
        return this.code;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Nullable
    public V getValue() {
        return this.value;
    }

    @Nullable
    public Map<String, Object> getParams() {
        return this.params;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Err)) {
            return false;
        }
        Err other = (Err)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        V this$value = this.getValue();
        V other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Map<String, Object> this$params = this.getParams();
        Map<String, Object> other$params = other.getParams();
        return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Err;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        V $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Map<String, Object> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        return result;
    }

    public String toString() {
        return "Err(field=" + this.getField() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", value=" + this.getValue() + ", params=" + this.getParams() + ")";
    }

    public static class ErrBuilder<V> {
        private String field;
        private String code;
        private String message;
        private V value;
        private Map<String, Object> params;

        public Err<V> build() {
            return new Err(this.field, this.code, this.message, this.value, this.params);
        }

        public ErrBuilder<V> field(String field) {
            this.field = field;
            return this;
        }

        public ErrBuilder<V> code(String code) {
            this.code = code;
            return this;
        }

        public ErrBuilder<V> code(Code code) {
            if (code != null) {
                this.code = code.getErrCode();
            }
            return this;
        }

        public ErrBuilder<V> message(String message) {
            this.message = message;
            return this;
        }

        public ErrBuilder<V> value(V value) {
            this.value = value;
            return this;
        }

        public ErrBuilder<V> params(Map<String, Object> params) {
            this.params = params;
            return this;
        }
    }

    public static interface Code {
        public String getErrCode();
    }
}

