/*
The MIT License (MIT)

Copyright (c) 2015 Nicholas Oppersdorff

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 */

package io.testworx.spock.exceldatareader.core

import org.apache.poi.hssf.usermodel.HSSFWorkbook
import org.apache.poi.ss.usermodel.Sheet
import org.apache.poi.ss.usermodel.Workbook
import org.apache.poi.xssf.usermodel.XSSFWorkbook

/*
 * This Groovy source file was auto generated by running 'gradle buildInit --type groovy-library'
 * by 'nvonop' at '12/11/15 18:53' with Gradle 2.7
 *
 * @author nvonop, @date 12/11/15 18:53
 */
class ExcelFileParser {

    private Workbook workbook
    private Sheet  worksheet
    FileInputStream inputStream

    public Sheet openExcel(String filePath,String fileName,String worksheetName) throws IOException{
        //Create a object of File class to open xlsx file
        File file =	new File(filePath+"//"+fileName);
        //Create an object of FileInputStream class to read excel file
        inputStream = new FileInputStream(file);
        workbook = getWorkbook(fileName)
        worksheet = workbook.getSheetAt(0)
        if (worksheetName.length()>0) {

        //Read sheet inside the workbook by its name
            int index = workbook.getNameIndex(worksheetName)
            worksheet = workbook.getSheet(worksheetName)
        }
        return worksheet;
    }

    private Workbook getWorkbook(String fileName) {
//        Workbook workbook

        //Find the file extension by spliting file name in substing and getting only extension name
        String fileExtensionName = fileName.substring(fileName.indexOf("."));
        //Check condition if the file is xlsx file
        if (fileExtensionName.equals(".xlsx")) {
            //If it is xlsx file then create object of XSSFWorkbook class
            workbook = new XSSFWorkbook(inputStream);
        }
        //Check condition if the file is xls file
        else if (fileExtensionName.equals(".xls")) {
            //If it is xls file then create object of XSSFWorkbook class
            workbook = new HSSFWorkbook(inputStream);
        }

        return workbook
    }

    public Sheet openExcel(String filePath,String fileName) throws IOException{
        openExcel(filePath, fileName, "")
    }
}
