/*
The MIT License (MIT)

Copyright (c) 2015 Nicholas Oppersdorff

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 */

package io.testworx.spock.exceldatareader.core

import org.apache.poi.ss.usermodel.Cell
import org.apache.poi.ss.usermodel.DateUtil

/*
 * This Groovy source file was auto generated by running 'gradle buildInit --type groovy-library'
 * by 'nvonop' at '12/11/15 18:53' with Gradle 2.7
 *
 * @author nvonop, @date 12/11/15 18:53
 */

class CellParser {

    public CellParser() {

    }

    public void addCellDataToList(Cell cell, ArrayList data) {
        switch (cell.getCellType()) {
            case Cell.CELL_TYPE_STRING:
                data.add(cell.getRichStringCellValue().getString())
                break;
            case Cell.CELL_TYPE_NUMERIC:
                if (DateUtil.isCellDateFormatted(cell)) {
                    data.add(cell.getDateCellValue())
                } else {
                    data.add(cell.getNumericCellValue())
                }
                break;
            case Cell.CELL_TYPE_BOOLEAN:
                data.add(cell.getBooleanCellValue())
                break;
            case Cell.CELL_TYPE_FORMULA:
                data.add(cell.getCellFormula())
                break;
            default:
                data.add(null)
        }
//        return data
    }

}
