/*
The MIT License (MIT)

Copyright (c) 2015 Nicholas Oppersdorff

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 */

package io.testworx.spock.exceldatareader.client

import io.testworx.spock.exceldatareader.core.CellParser
import io.testworx.spock.exceldatareader.core.ColumnParser
import io.testworx.spock.exceldatareader.core.ExcelFileParser
import io.testworx.spock.exceldatareader.core.RowParser
import org.apache.poi.ss.usermodel.Row
import org.apache.poi.ss.usermodel.Sheet

/*
 * This Groovy source file was auto generated by running 'gradle buildInit --type groovy-library'
 * by 'nvonop' at '12/11/15 18:53' with Gradle 2.7
 *
 * @author nvonop, @date 12/11/15 18:53
 */

class ExcelDataReader {

    private ExcelFileParser fileParser
    private Sheet dataSheet
    private RowParser rowParser
    private ColumnParser columnParser
    private CellParser cellParser
    private List data;

    public ExcelDataReader(String filepath, String filename, String worksheet) {
        fileParser = new ExcelFileParser()
        dataSheet = fileParser.openExcel(filepath, filename, worksheet)
    }

    public ExcelDataReader(String filepath, String filename) {
        fileParser = new ExcelFileParser()
        dataSheet = fileParser.openExcel(filepath, filename)
    }

    public List getDataFromColumn(int columnIndex) {
        columnParser = new ColumnParser(dataSheet)
        return columnParser.columnDataToList(columnIndex)
    }

    public List getDataFromColumn(String name) {
        rowParser = new RowParser(dataSheet)
        int columnIndex = rowParser.getColumnIndexFromName(name)

        return getDataFromColumn(columnIndex)
    }

    public List getDataFromColumn(int columnIndex, int rowStartIndex) {
        columnParser = new ColumnParser(dataSheet)
        return columnParser.columnDataToList(columnIndex, rowStartIndex)
    }

    public List getDataFromColumn(String name, int rowStartIndex) {
        rowParser = new RowParser(dataSheet)
        int columnIndex = rowParser.getColumnIndexFromName(name)

        return getDataFromColumn(columnIndex, rowStartIndex)
    }

    public List getDataFromRow(int rowIndex) {
        rowParser = new RowParser(dataSheet)
        Row row = dataSheet.getRow(rowIndex)
        return rowParser.rowDataToList(row)
    }

    public List getDataFromRow(String name) {
        rowParser = new RowParser(dataSheet)
        Iterator rowIterator = dataSheet.rowIterator()
        while (rowIterator.hasNext()) {
            Row row = (Row) rowIterator.next()
            if(row.getCell(0).getStringCellValue().trim().equalsIgnoreCase(name)) {
                return rowParser.rowDataToList(row)
            }
        }
        return null
    }

    //Added to address issue #1
    public List getDataFromRow(int rowIndex, int columnStartIndex) {
        rowParser = new RowParser(dataSheet)
        Row row = dataSheet.getRow(rowIndex)
        return rowParser.rowDataToList(row, columnStartIndex)
    }

    //Added to address issue #1
    public List getDataFromRow(String name, int columnStartIndex) {
        rowParser = new RowParser(dataSheet)
        Iterator rowIterator = dataSheet.rowIterator()
        while (rowIterator.hasNext()) {
            Row row = (Row) rowIterator.next()
            if(row.getCell(0).getStringCellValue().trim().equalsIgnoreCase(name)) {
                return rowParser.rowDataToList(row, columnStartIndex)
            }
        }
        return null
    }

    /**
     * This method returns the value for a specific cell based on the row name provided and the column index
     * Note:  columnIndex is zero based
     * @param rowName
     * @param columnIndex
     * @return
     */
    //Added to address issue #6
    public String getDataFromCell(String rowName, int columnIndex) {
        def rowValues = getDataFromRow rowName
        return rowValues[columnIndex]
    }

    public String getCurrentWorksheetName() {
        return dataSheet.getSheetName()
    }






}
