/*
 * Decompiled with CFR 0.152.
 */
package io.tesfy.config;

import io.tesfy.config.Allocation;
import io.tesfy.config.Datafile;
import io.tesfy.config.Experiment;
import io.tesfy.config.Feature;
import io.tesfy.config.Variation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00122\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00160\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/tesfy/config/Config;", "", "datafile", "Lio/tesfy/config/Datafile;", "maxBuckets", "", "(Lio/tesfy/config/Datafile;I)V", "computeRangeEnd", "", "percentage", "getExperiment", "Lio/tesfy/config/Experiment;", "id", "", "getExperimentAllocation", "Lio/tesfy/config/Allocation;", "experimentId", "getExperimentAllocations", "", "getExperiments", "", "getFeature", "Lio/tesfy/config/Feature;", "getFeatureAllocation", "getFeatures", "tesfy-kotlin"})
public final class Config {
    private final Datafile datafile;
    private final int maxBuckets;

    private final long computeRangeEnd(int percentage) {
        double d = (double)(this.maxBuckets * percentage) / (double)100;
        boolean bl = false;
        return (long)Math.floor(d);
    }

    @NotNull
    public final Map<String, Experiment> getExperiments() {
        return this.datafile.getExperiments();
    }

    @Nullable
    public final Experiment getExperiment(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.datafile.getExperiments().get(id);
    }

    @NotNull
    public final Map<String, Feature> getFeatures() {
        return this.datafile.getFeatures();
    }

    @Nullable
    public final Feature getFeature(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.datafile.getFeatures().get(id);
    }

    @Nullable
    public final Allocation getFeatureAllocation(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Feature feature = this.getFeature(id);
        if (feature == null) {
            return null;
        }
        Feature feature2 = feature;
        long rangeEnd = this.computeRangeEnd(feature2.getPercentage());
        return new Allocation(id, rangeEnd);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Allocation> getExperimentAllocations(@NotNull String id) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Experiment experiment = this.getExperiment(id);
        if (experiment == null) {
            return CollectionsKt.emptyList();
        }
        Experiment experiment2 = experiment;
        int acc = 0;
        Iterable $this$map$iv = experiment2.getVariations();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void variation;
            Variation variation2 = (Variation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            long rangeEnd = this.computeRangeEnd(acc += variation.getPercentage());
            Allocation allocation = new Allocation(variation.getId(), rangeEnd);
            collection.add(allocation);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final Allocation getExperimentAllocation(@NotNull String experimentId) {
        Intrinsics.checkNotNullParameter((Object)experimentId, (String)"experimentId");
        Experiment experiment = this.getExperiment(experimentId);
        if (experiment == null) {
            return null;
        }
        Experiment experiment2 = experiment;
        long rangeEnd = this.computeRangeEnd(experiment2.getPercentage());
        return new Allocation(experiment2.getId(), rangeEnd);
    }

    public Config(@NotNull Datafile datafile, int maxBuckets) {
        Intrinsics.checkNotNullParameter((Object)datafile, (String)"datafile");
        this.datafile = datafile;
        this.maxBuckets = maxBuckets;
    }
}

