/*
 * Decompiled with CFR 0.152.
 */
package io.terraformkt.utils;

import io.terraformkt.plugin.generators.ResourceType;
import io.terraformkt.utils.Json;
import io.terraformkt.utils.NamesUtils$WhenMappings;
import io.terraformkt.utils.Text;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u0002J\u0016\u0010\u0010\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\u0003R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/terraformkt/utils/NamesUtils;", "", "provider", "", "(Ljava/lang/String;)V", "mappings", "", "getClassFilePath", "resourceType", "Lio/terraformkt/plugin/generators/ResourceType;", "className", "getClassPackageName", "getDirectoryName", "getFirstWordCamelCase", "word", "getMappings", "getPackageName", "getProviderFilePath", "getProviderPackageName", "Companion", "plugin"})
public final class NamesUtils {
    private final Map<String, String> mappings;
    private final String provider;
    private static final String PACKAGE_PREFIX = "io.terraformkt";
    private static final String PATH_PREFIX = "io/terraformkt";
    private static final String RESOURCES_DIRECTORY_NAME = "resource";
    private static final String DATA_DIRECTORY_NAME = "data";
    private static final String PROVIDER_DIRECTORY_NAME = "provider";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getClassFilePath(@NotNull ResourceType resourceType, @NotNull String className) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)resourceType), (String)"resourceType");
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        return "io/terraformkt/" + this.provider + '/' + this.getDirectoryName(resourceType) + '/' + this.getClassPackageName(className) + '/' + className + ".kt";
    }

    @NotNull
    public final String getProviderFilePath() {
        return "io/terraformkt/" + this.provider + "/provider/Provider.kt";
    }

    @NotNull
    public final String getPackageName(@NotNull ResourceType resourceType, @NotNull String className) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)resourceType), (String)"resourceType");
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        return "io.terraformkt." + this.provider + '.' + this.getDirectoryName(resourceType) + '.' + this.getClassPackageName(className);
    }

    @NotNull
    public final String getProviderPackageName() {
        return "io.terraformkt." + this.provider + ".provider";
    }

    private final Map<String, String> getMappings() {
        URL uRL = this.getClass().getClassLoader().getResource("package_mapping.json");
        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"javaClass.classLoader.ge\u2026e(\"package_mapping.json\")");
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        boolean bl2 = false;
        boolean bl3 = false;
        String mappings = new String(byArray, charset);
        Json this_$iv = Json.INSTANCE;
        boolean $i$f$parse = false;
        Object object = this_$iv.getMoshi().adapter(Map.class).fromJson(mappings);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
        }
        return (Map)object;
    }

    private final String getDirectoryName(ResourceType resourceType) {
        String string;
        switch (NamesUtils$WhenMappings.$EnumSwitchMapping$0[resourceType.ordinal()]) {
            case 1: {
                string = RESOURCES_DIRECTORY_NAME;
                break;
            }
            case 2: {
                string = DATA_DIRECTORY_NAME;
                break;
            }
            case 3: {
                string = PROVIDER_DIRECTORY_NAME;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String getClassPackageName(String className) {
        Object v0;
        boolean bl;
        Object object;
        block3: {
            object = this.mappings.entrySet();
            bl = false;
            Iterable iterable = object;
            boolean bl2 = false;
            for (Object t : iterable) {
                Map.Entry entry = (Map.Entry)t;
                boolean bl3 = false;
                if (!StringsKt.startsWith$default((String)className, (String)((String)entry.getKey()), (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        Map.Entry packageNameEntry = v0;
        if (packageNameEntry != null) {
            return (String)packageNameEntry.getValue();
        }
        object = this.getFirstWordCamelCase(className);
        bl = false;
        Object object2 = object;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string = ((String)object2).toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).toLowerCase()");
        return string;
    }

    private final String getFirstWordCamelCase(String word) {
        return Text.INSTANCE.decamelize(word).get(0);
    }

    public NamesUtils(@NotNull String provider) {
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)PROVIDER_DIRECTORY_NAME);
        this.provider = provider;
        this.mappings = this.getMappings();
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/terraformkt/utils/NamesUtils$Companion;", "", "()V", "DATA_DIRECTORY_NAME", "", "PACKAGE_PREFIX", "PATH_PREFIX", "PROVIDER_DIRECTORY_NAME", "RESOURCES_DIRECTORY_NAME", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

