/*
 * Decompiled with CFR 0.152.
 */
package io.terraformkt.plugin.tasks;

import io.terraformkt.plugin.DSLKt;
import io.terraformkt.plugin.TerraformKt;
import io.terraformkt.wrapper.TerraformWrapper;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007R\u0011\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8G\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\b8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u000f"}, d2={"Lio/terraformkt/plugin/tasks/DownloadSchemaTask;", "Lorg/gradle/api/DefaultTask;", "()V", "downloadPath", "Ljava/io/File;", "getDownloadPath", "()Ljava/io/File;", "providerName", "", "getProviderName", "()Ljava/lang/String;", "providerVersion", "getProviderVersion", "download", "", "plugin"})
public class DownloadSchemaTask
extends DefaultTask {
    @Input
    @Nullable
    public final String getProviderName() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return DSLKt.getTerraformKt(project).getProvider().getName();
    }

    @Input
    @Nullable
    public final String getProviderVersion() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return DSLKt.getTerraformKt(project).getProvider().getVersion();
    }

    @InputDirectory
    @NotNull
    public final File getDownloadPath() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        TerraformKt.Terraform terraform = DSLKt.getTerraformKt(project).getTerraform();
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        return terraform.getDownloadPathOrDefault$plugin(project2);
    }

    @TaskAction
    public final void download() {
        boolean bl = this.getProviderName() != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "provider name is not specified";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.getProviderVersion() != null;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "provider version is not specified ";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        File file = this.getDownloadPath();
        String string = this.getProviderName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String string2 = this.getProviderVersion();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        TerraformWrapper.Download.INSTANCE.schema(file, string, string2);
    }

    public DownloadSchemaTask() {
        this.setGroup("terraformkt");
    }
}

