/*
 * Decompiled with CFR 0.152.
 */
package io.terraformkt.plugin.tasks;

import io.terraformkt.plugin.DSLKt;
import io.terraformkt.plugin.TerraformKt;
import io.terraformkt.wrapper.TerraformWrapper;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0007R\u0011\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\u00020\u00048G\u00a2\u0006\f\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\u0006R\u0011\u0010\n\u001a\u00020\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lio/terraformkt/plugin/tasks/DownloadTerraformTask;", "Lorg/gradle/api/DefaultTask;", "()V", "downloadPath", "Ljava/io/File;", "getDownloadPath", "()Ljava/io/File;", "terraformFile", "terraformFile$annotations", "getTerraformFile", "version", "", "getVersion", "()Ljava/lang/String;", "download", "", "plugin"})
public class DownloadTerraformTask
extends DefaultTask {
    @Input
    @NotNull
    public final String getVersion() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return DSLKt.getTerraformKt(project).getTerraform().getVersion();
    }

    @InputDirectory
    @NotNull
    public final File getDownloadPath() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        TerraformKt.Terraform terraform = DSLKt.getTerraformKt(project).getTerraform();
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        return terraform.getDownloadPathOrDefault$plugin(project2);
    }

    public static /* synthetic */ void terraformFile$annotations() {
    }

    @OutputFile
    @NotNull
    public final File getTerraformFile() {
        return FilesKt.resolve((File)this.getDownloadPath(), (String)"terraform");
    }

    @TaskAction
    public final void download() {
        this.getLogger().lifecycle("Downloading terraform version " + this.getVersion());
        TerraformWrapper.Download.INSTANCE.terraform(this.getDownloadPath(), this.getVersion());
        this.getLogger().lifecycle("Terraform version " + this.getVersion() + " successfully downloaded");
    }

    public DownloadTerraformTask() {
        this.setGroup("terraformkt");
    }
}

