/*
 * Decompiled with CFR 0.152.
 */
package io.terraformkt.plugin.generators;

import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.LambdaTypeName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.TypeVariableName;
import io.terraformkt.Configuration;
import io.terraformkt.plugin.generators.ResourceType;
import io.terraformkt.plugin.generators.ResourceTypeKt;
import io.terraformkt.plugin.generators.UtilsKt;
import io.terraformkt.terraform.TFFile;
import io.terraformkt.utils.NamesUtils;
import io.terraformkt.utils.Text;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ)\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u001c\u0010\u0013\u001a\u00020\u0014*\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0015\u001a\u00020\u0016*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/terraformkt/plugin/generators/ResourcesAndDataGenerator;", "", "generationPath", "Ljava/io/File;", "providerName", "", "packageNameProvider", "Lio/terraformkt/utils/NamesUtils;", "(Ljava/io/File;Ljava/lang/String;Lio/terraformkt/utils/NamesUtils;)V", "generateResourceOrData", "", "resources", "", "Lio/terraformkt/Configuration;", "resourceType", "Lio/terraformkt/plugin/generators/ResourceType;", "generateResourceOrData$plugin", "removeProviderPrefix", "resourceName", "addClassKDoc", "Lcom/squareup/kotlinpoet/TypeSpec$Builder;", "addClosureFunctions", "Lcom/squareup/kotlinpoet/FileSpec$Builder;", "functionName", "className", "plugin"})
public final class ResourcesAndDataGenerator {
    private final File generationPath;
    private final String providerName;
    private final NamesUtils packageNameProvider;

    /*
     * WARNING - void declaration
     */
    public final void generateResourceOrData$plugin(@NotNull Map<String, Configuration> resources, @NotNull ResourceType resourceType) {
        Intrinsics.checkParameterIsNotNull(resources, (String)"resources");
        Intrinsics.checkParameterIsNotNull((Object)((Object)resourceType), (String)"resourceType");
        for (String resourceName : resources.keySet()) {
            String className = Text.INSTANCE.snakeToCamelCase(this.removeProviderPrefix(resourceName));
            FileSpec.Builder fileBuilder = FileSpec.Companion.builder(this.packageNameProvider.getPackageName(resourceType, className), className);
            TypeSpec.Builder resourceClassBuilder = ResourceTypeKt.addSuperClass(this.addClassKDoc(TypeSpec.Companion.classBuilder(className).primaryConstructor(FunSpec.Companion.constructorBuilder().addParameter("id", Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]).build()), resourceName, resourceType), resourceType).addSuperclassConstructorParameter("id", new Object[0]).addSuperclassConstructorParameter('\"' + resourceName + '\"', new Object[0]);
            Configuration resource = (Configuration)MapsKt.getValue(resources, (Object)resourceName);
            if (resource.getBlock().getAttributes() != null) {
                Object object = resource.getBlock().getAttributes();
                boolean bl = false;
                Iterator<Map.Entry<String, Map<String, Object>>> iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    void attributeName;
                    Map.Entry<String, Map<String, Object>> entry;
                    Map.Entry<String, Map<String, Object>> entry2 = entry = iterator.next();
                    boolean bl2 = false;
                    object = entry2.getKey();
                    entry2 = entry;
                    bl2 = false;
                    Map<String, Object> attribute = entry2.getValue();
                    UtilsKt.addAttribute(resourceClassBuilder, (String)attributeName, attribute);
                }
            }
            if (resource.getBlock().getBlock_types() != null) {
                UtilsKt.generateBlockTypes(resourceClassBuilder, resource.getBlock().getBlock_types());
            }
            this.addClosureFunctions(fileBuilder.addType(resourceClassBuilder.build()), this.removeProviderPrefix(resourceName), className);
            File file = FilesKt.resolve((File)this.generationPath, (String)this.packageNameProvider.getClassFilePath(resourceType, className));
            file.getParentFile().mkdirs();
            file.createNewFile();
            FilesKt.writeText$default((File)file, (String)fileBuilder.build().toString(), null, (int)2, null);
        }
    }

    private final String removeProviderPrefix(String resourceName) {
        return StringsKt.substringAfter$default((String)resourceName, (String)"_", null, (int)2, null);
    }

    private final TypeSpec.Builder addClassKDoc(@NotNull TypeSpec.Builder $this$addClassKDoc, String resourceName, ResourceType resourceType) {
        return $this$addClassKDoc.addKdoc(StringsKt.trimMargin$default((String)("Terraform " + resourceName + " resource.\n            | \n            | @see <a href=\"https://www.terraform.io/docs/providers/" + this.providerName + '/' + resourceType.getFirstLetter() + '/' + this.removeProviderPrefix(resourceName) + ".html\">" + resourceName + "</a>\n        "), null, (int)1, null), new Object[0]);
    }

    private final FileSpec.Builder addClosureFunctions(@NotNull FileSpec.Builder $this$addClosureFunctions, String functionName, String className) {
        TypeName typeName = (TypeName)TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)className, null, (int)2, null);
        List list = null;
        TypeName typeName2 = (TypeName)TypeNames.UNIT;
        FileSpec.Builder builder = $this$addClosureFunctions.addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder(functionName).addParameter("id", Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]).addParameter("configure", (TypeName)LambdaTypeName.Companion.get$default((LambdaTypeName.Companion)LambdaTypeName.Companion, (TypeName)typeName, list, (TypeName)typeName2, (int)2, null), new KModifier[0]).addStatement("return %N(id).apply(configure)", new Object[]{className}), (TypeName)((TypeName)TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)className, null, (int)2, null)), null, (int)2, null).build());
        typeName = (TypeName)TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)className, null, (int)2, null);
        list = null;
        typeName2 = (TypeName)TypeNames.UNIT;
        return builder.addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Builder.receiver$default((FunSpec.Builder)FunSpec.Companion.builder(functionName), (KClass)Reflection.getOrCreateKotlinClass(TFFile.class), null, (int)2, null).addParameter("id", Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]).addParameter("configure", (TypeName)LambdaTypeName.Companion.get$default((LambdaTypeName.Companion)LambdaTypeName.Companion, (TypeName)typeName, list, (TypeName)typeName2, (int)2, null), new KModifier[0]).addStatement("val element = %N(id).apply(configure)", new Object[]{className}).addStatement("%N(element)", new Object[]{"add"}).addStatement("return element", new Object[0]), (TypeName)((TypeName)TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)className, null, (int)2, null)), null, (int)2, null).build());
    }

    public ResourcesAndDataGenerator(@NotNull File generationPath, @NotNull String providerName, @NotNull NamesUtils packageNameProvider) {
        Intrinsics.checkParameterIsNotNull((Object)generationPath, (String)"generationPath");
        Intrinsics.checkParameterIsNotNull((Object)providerName, (String)"providerName");
        Intrinsics.checkParameterIsNotNull((Object)packageNameProvider, (String)"packageNameProvider");
        this.generationPath = generationPath;
        this.providerName = providerName;
        this.packageNameProvider = packageNameProvider;
    }
}

