/*
 * Decompiled with CFR 0.152.
 */
package io.terraformkt.plugin.generators;

import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.LambdaTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.TypeVariableName;
import io.terraformkt.Configuration;
import io.terraformkt.plugin.generators.FieldTypeKt;
import io.terraformkt.plugin.generators.FieldTypeWithDelegate;
import io.terraformkt.plugin.generators.ResourceType;
import io.terraformkt.plugin.generators.ResourceTypeKt;
import io.terraformkt.plugin.generators.UtilsKt;
import io.terraformkt.terraform.TFFile;
import io.terraformkt.utils.NamesUtils;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/terraformkt/plugin/generators/ProviderGenerator;", "", "providerName", "", "packageNameProvider", "Lio/terraformkt/utils/NamesUtils;", "generationPath", "Ljava/io/File;", "(Ljava/lang/String;Lio/terraformkt/utils/NamesUtils;Ljava/io/File;)V", "generateProvider", "", "provider", "Lio/terraformkt/Configuration;", "generateVersionProperty", "Lcom/squareup/kotlinpoet/PropertySpec;", "addClosureFunctionsToProvider", "Lcom/squareup/kotlinpoet/FileSpec$Builder;", "functionName", "className", "addProviderKDoc", "Lcom/squareup/kotlinpoet/TypeSpec$Builder;", "plugin"})
public final class ProviderGenerator {
    private final String providerName;
    private final NamesUtils packageNameProvider;
    private final File generationPath;

    /*
     * WARNING - void declaration
     */
    public final void generateProvider(@NotNull Configuration provider) {
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        String className = "Provider";
        FileSpec.Builder fileBuilder = FileSpec.Companion.builder(this.packageNameProvider.getProviderPackageName(), className);
        TypeSpec.Builder resourceClassBuilder = ResourceTypeKt.addSuperClass(this.addProviderKDoc(TypeSpec.Companion.classBuilder(className)), ResourceType.PROVIDER).addSuperclassConstructorParameter('\"' + this.providerName + '\"', new Object[0]);
        resourceClassBuilder.addProperty(this.generateVersionProperty());
        if (provider.getBlock().getAttributes() != null) {
            Object object = provider.getBlock().getAttributes();
            boolean bl = false;
            Iterator<Map.Entry<String, Map<String, Object>>> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void attributeName;
                Map.Entry<String, Map<String, Object>> entry;
                Map.Entry<String, Map<String, Object>> entry2 = entry = iterator.next();
                boolean bl2 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                Map<String, Object> attribute = entry2.getValue();
                UtilsKt.addAttribute(resourceClassBuilder, (String)attributeName, attribute);
            }
        }
        if (provider.getBlock().getBlock_types() != null) {
            UtilsKt.generateBlockTypes(resourceClassBuilder, provider.getBlock().getBlock_types());
        }
        File file = FilesKt.resolve((File)this.generationPath, (String)this.packageNameProvider.getProviderFilePath());
        file.getParentFile().mkdirs();
        file.createNewFile();
        this.addClosureFunctionsToProvider(fileBuilder.addType(resourceClassBuilder.build()), "provider", className);
        FilesKt.writeText$default((File)file, (String)fileBuilder.build().toString(), null, (int)2, null);
    }

    private final TypeSpec.Builder addProviderKDoc(@NotNull TypeSpec.Builder $this$addProviderKDoc) {
        return $this$addProviderKDoc.addKdoc(StringsKt.trimMargin$default((String)(this.providerName + " Terraform provider.\n            | \n            | @see <a href=\"https://www.terraform.io/docs/providers/" + this.providerName + "/index.html\">" + this.providerName + " provider</a>\n        "), null, (int)1, null), new Object[0]);
    }

    private final FileSpec.Builder addClosureFunctionsToProvider(@NotNull FileSpec.Builder $this$addClosureFunctionsToProvider, String functionName, String className) {
        TypeName typeName = (TypeName)TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)className, null, (int)2, null);
        List list = null;
        TypeName typeName2 = (TypeName)TypeNames.UNIT;
        FileSpec.Builder builder = $this$addClosureFunctionsToProvider.addFunction(FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder(functionName).addParameter("configure", (TypeName)LambdaTypeName.Companion.get$default((LambdaTypeName.Companion)LambdaTypeName.Companion, (TypeName)typeName, list, (TypeName)typeName2, (int)2, null), new KModifier[0]).addStatement("return %N().apply(configure)", new Object[]{className}), (TypeName)((TypeName)TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)className, null, (int)2, null)), null, (int)2, null).build());
        typeName = (TypeName)TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)className, null, (int)2, null);
        list = null;
        typeName2 = (TypeName)TypeNames.UNIT;
        return builder.addFunction(FunSpec.Builder.receiver$default((FunSpec.Builder)FunSpec.Companion.builder(functionName), (KClass)Reflection.getOrCreateKotlinClass(TFFile.class), null, (int)2, null).addParameter("configure", (TypeName)LambdaTypeName.Companion.get$default((LambdaTypeName.Companion)LambdaTypeName.Companion, (TypeName)typeName, list, (TypeName)typeName2, (int)2, null), new KModifier[0]).addStatement("%N(%N().apply(configure))", new Object[]{"add", className}).build());
    }

    private final PropertySpec generateVersionProperty() {
        FieldTypeWithDelegate type = FieldTypeWithDelegate.STRING;
        PropertySpec.Builder propertyBuilder = PropertySpec.Companion.builder("version", type.getTypeName(), new KModifier[0]).delegate(FieldTypeKt.typeToDelegate(type), new Object[0]).mutable(true);
        return propertyBuilder.build();
    }

    public ProviderGenerator(@NotNull String providerName, @NotNull NamesUtils packageNameProvider, @NotNull File generationPath) {
        Intrinsics.checkParameterIsNotNull((Object)providerName, (String)"providerName");
        Intrinsics.checkParameterIsNotNull((Object)packageNameProvider, (String)"packageNameProvider");
        Intrinsics.checkParameterIsNotNull((Object)generationPath, (String)"generationPath");
        this.providerName = providerName;
        this.packageNameProvider = packageNameProvider;
        this.generationPath = generationPath;
    }
}

