/*
 * Decompiled with CFR 0.152.
 */
package io.teris.kite.rpc;

import io.teris.kite.rpc.InvocationException;
import io.teris.kite.rpc.ServiceProxyUtil;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.annotation.Nonnull;

final class ServiceValidator {
    private ServiceValidator() {
    }

    static <S> void validate(@Nonnull Class<S> serviceClass) throws InvocationException {
        if (!serviceClass.isInterface()) {
            String message = String.format("Service definition %s must be an interface", serviceClass.getSimpleName());
            throw new InvocationException(message);
        }
        Method[] methods = serviceClass.getDeclaredMethods();
        if (methods.length < 1) {
            String message = String.format("Service definition %s must declare at least one method", serviceClass.getSimpleName());
            throw new InvocationException(message);
        }
        HashSet<String> foundMethodNames = new HashSet<String>();
        for (Method method : methods) {
            if (foundMethodNames.contains(method.getName())) {
                String message = String.format("Service definition %s must not declare any overloaded methods (violation: %s)", serviceClass.getSimpleName(), method.getName());
                throw new InvocationException(message);
            }
            ServiceProxyUtil.route(method);
            ServiceProxyUtil.validateArgumentTypes(method);
            ServiceProxyUtil.returnType(method);
            foundMethodNames.add(method.getName());
        }
    }
}

